#include <cstdio>
#include <deque>
#include <algorithm>
#include <cstring>

using namespace std;

const int MAXN = 105;

int _dist[MAXN][MAXN][4];

struct state{
  int x, y, t;
  state (int x = 0, int y = 0, int t = 0) : x(x), y(y), t(t) {}
  int& dist (){
    return _dist[x][y][t];
  }
};

int n, m;
char mat[MAXN][MAXN];

enum {RIGHT, LEFT, DOWN, UP};
int dx[] = {0, 0, 1,-1};
int dy[] = {1,-1, 0, 0};

deque <state> Q;

enum {ONBASE, HORIZONTAL, VERTICAL};

int switchState (int t, int p){
  if (t == ONBASE){
    if (p == LEFT || p == RIGHT) return HORIZONTAL;
    return VERTICAL;
  }

  if (t == HORIZONTAL){
    if (p == LEFT || p == RIGHT) return ONBASE;
    return HORIZONTAL;
  }
  
  if (t == VERTICAL){
    if (p == LEFT || p == RIGHT) return VERTICAL;
    return ONBASE;
  }
}

int main (void){
  scanf("%d%d", &n, &m);
  for (int i = 0; i < n; ++i)
    scanf("%s", mat[i]);

  memset(_dist, 1, sizeof _dist);
  int sx, sy;

  for (int i = 0; i < n; ++i)
    for (int j = 0; j < n; ++j)
      if (mat[i][j] == 'S') sx = i, sy = j;

  Q.push_back(state(sx, sy, ONBASE));
  Q.front().dist() = 0;

  while (!Q.empty()){
    state curr = Q.front(); 
    Q.pop_front();
    if (mat[curr.x][curr.y] == 'F'){
      printf("%d\n", curr.dist());
      return 0;
    }

    for (int i = 0; i < 4; ++i){
      state nxt = state(curr.x + dx[i], curr.y + dy[i], switchState(curr.t, i));
      if (nxt.x < 0 || nxt.y < 0 || nxt.x >= n || nxt.y >= m) continue;
      if (mat[nxt.x][nxt.y] == '#') continue;
      int ndist = curr.dist() + (nxt.t != curr.t);
      if (ndist >= nxt.dist()) continue;
      nxt.dist() = ndist;
      if (nxt.t != curr.t) Q.push_back(nxt);
      else Q.push_front(nxt);
    }
  }

  return 0;
}
