#include <cstdio>
#include <iostream>
#include <cstring>
#include <vector>
#include <set>
#include <algorithm>

using namespace std;

const int MaxN = 100010;

struct event {
  int tip, idx, x;

  event(int _tip, int _idx, int _x) {
    tip = _tip;
    idx = _idx;
    x = _x;
  }
};

bool cmpf(event A, event B) {
  if (A.x != B.x) return A.x < B.x;
  return A.tip > B.tip;
}

int N, K, n, a[MaxN], b[MaxN], start[MaxN];
vector <event> E;
set <int> S;

int main(void) {
  scanf("%d %d",&N,&K);
  for (int i = 0; i < K; ++i) {
    scanf("%d %d",&a[i],&b[i]);
    E.push_back(event(0, i, a[i]));
    E.push_back(event(1, i, b[i] + 1));
  }
  sort(E.begin(), E.end(), cmpf);

  S.insert(n);
  n = 1;
  for (int i = 0; i < E.size(); ++i) 
    if (E[i].tip == 0) {
      if (S.empty()) {
	S.insert(n);
	++n;
      }
      start[E[i].idx] = *S.begin();
      S.erase(S.begin());
    }
    else 
      S.insert(start[E[i].idx]);
    
  printf("%d\n",n);
  for (int i = 0; i < K; ++i)
    printf("%d\n",start[i]);

  return 0;
}
