
/*
Izborne pripreme 2002, Prvi izborni ispit
Zadatak SEF, Programski jezik C
*/

#include <stdio.h>
#include <stdlib.h>

#define MAXN            100000
#define INFILE			"sef.in"
#define OUTFILE			"sef.out"
#define BROJDIJELOVA    10000000LL

#define MIN(A, B)		(((A)<(B))?(A):(B))

long long rupe[2*MAXN];
int broj_krugova;

int cmp ( const void *e1, const void *e2 )
{
	if (*(long long *)e1 < *(long long *)e2) return -1;
	return 1;
}

void load_data ( void )
{
	int i;
	FILE *f=fopen (INFILE, "rt");

	fscanf (f, "%d", &broj_krugova);
	for (i=0; i<broj_krugova; i++)
	{
		fscanf (f, "%lld", rupe+i);
		rupe[i]--;
	}

	fclose (f);
}

long long solve ( void )
{
	int i, j, csindex;
	long long summe, best, fix;

    // sortiraj kutove po velicini
    qsort (rupe, broj_krugova, sizeof(long long), cmp);

    // poduplaj polje
    for (i=0; i<broj_krugova; i++)
    	rupe[i+broj_krugova]=rupe[i]+BROJDIJELOVA;

    // prebroji koliki je ukupni kut ako sve rupe postavim na prvog
	fix=rupe[0]; best=0;
	for (j=0; j<broj_krugova; j++)
	{
		// zbroji manju udaljenost od rupe[j] do fix
		best=best+MIN((rupe[j]-fix+BROJDIJELOVA)%BROJDIJELOVA,
					(fix-rupe[j]+BROJDIJELOVA)%BROJDIJELOVA);
	}

	// nadji gdje je centralno simetricni
    csindex=0;
    while (rupe[++csindex]-rupe[0]<BROJDIJELOVA/2);

    // za svaki izracunaj koliki je kut ako na njega fixiram
    summe=best;
    for (j=1; j<broj_krugova; j++)
    {
        // oni koji se okrecu ulijevo, trebaju se okretati manje
        summe=summe-(csindex-j)*(rupe[j]-rupe[j-1]);

        // oni koji se okrecu udesno, okrecu se vise
        summe=summe+(broj_krugova-csindex+j)*(rupe[j]-rupe[j-1]);

        // provjeri da li se csindex treba zakrenuti lijevo a ne desno
        while (rupe[csindex]-rupe[j]<BROJDIJELOVA/2)
        {
            // prebaci ga da se ne mice udesno vec ulijevo
            summe=summe-(BROJDIJELOVA+rupe[j]-rupe[csindex]);
            summe=summe+(rupe[csindex]-rupe[j]);
        	csindex++;
        }

    	if (summe < best) best=summe;
    }

	return best;
}

void write_solution ( long long sol )
{
	FILE *f=fopen (OUTFILE, "wt");

	fprintf (f, "%lld\n", sol);
	fclose (f);
}

int main ( void )
{
	load_data();
	write_solution (solve());

	return 0;
}
