
(*
 Izborne pripreme 2002. - 1. izborni ispit - 1. zadatak - SEF
 Rjesenje napisao: Davor Bonaci <dbonaci@vip.hr>
*)

program sef(input, output);
type
  tip = int64;
const
  MAXN = 100000;
  INFILE = 'sef.in';
  OUTFILE = 'sef.out';
  BROJDIJELOVA = 10000000;

var
  rupe : array[0..2*MAXN] of tip;
  broj_krugova : longint;
  rjesenje : tip;

procedure qsort(l, r : longint);
var
  i, j : longint;
  x, y : tip;
begin
  i := l; j := r; x := rupe[(l+r) DIV 2];
  repeat
    while rupe[i] < x do i := i + 1;
    while x < rupe[j] do j := j - 1;
    if i <= j then
    begin
      y := rupe[i]; rupe[i] := rupe[j]; rupe[j] := y;
      i := i + 1; j := j - 1;
    end;
  until i > j;
  if l < j then qsort(l, j);
  if i < r then qsort(i, r);
end;

procedure load_data;
var
  i : longint;
  f : text;
begin
	assign(f, INFILE); reset(f);

	read(f, broj_krugova);

	for i:=0 to broj_krugova-1 do
	begin
		read(f, rupe[i]);
		dec(rupe[i]);
	end;

	close(f);
end;

procedure solve;
var
  i, j, csindex : longint;
  summe, best, fix : tip;
begin
    { sortiraj kutove po velicini }
    qsort(0, broj_krugova - 1);

    { poduplaj polje }
    for i:=0 to broj_krugova-1 do
    	rupe[i+broj_krugova] := rupe[i] + BROJDIJELOVA;

    { prebroji koliki je ukupni kut ako sve rupe postavim na prvog }
	fix := rupe[0]; best := 0;
	for j:=0 to broj_krugova-1 do
	  { zbroji manju udaljenost od rupe[j] do fix }
          if (((rupe[j]-fix+BROJDIJELOVA) mod BROJDIJELOVA) <
              ((fix-rupe[j]+BROJDIJELOVA) mod BROJDIJELOVA)) then
                inc(best, (rupe[j]-fix+BROJDIJELOVA) mod BROJDIJELOVA)
              else
                inc(best, (fix-rupe[j]+BROJDIJELOVA) mod BROJDIJELOVA);

    { nadji gdje je centralno simetricni }
    csindex := 0;
    inc(csindex);
    while (rupe[csindex]-rupe[0]<BROJDIJELOVA / 2) do
      inc(csindex);

    { za svaki izracunaj koliki je kut ako na njega fixiram }
    summe := best;
    for j:=1 to broj_krugova do
    begin
        { oni koji se okrecu ulijevo, trebaju se okretati manje }
        summe := summe-(csindex-j)*(rupe[j]-rupe[j-1]);

        { oni koji se okrecu udesno, okrecu se vise }
        summe := summe+(broj_krugova-csindex+j)*(rupe[j]-rupe[j-1]);

        { provjeri da li se csindex treba zakrenuti lijevo a ne desno }
        while (rupe[csindex]-rupe[j]<BROJDIJELOVA / 2) do
        begin
            { prebaci ga da se ne mice udesno vec ulijevo }
            summe := summe-(BROJDIJELOVA+rupe[j]-rupe[csindex]);
            summe := summe+(rupe[csindex]-rupe[j]);
        	inc(csindex);
        end;
    	if (summe < best) then best := summe;
    end;

    rjesenje := best;
end;

procedure write_solution;
var
  f : text;
begin
	assign(f, OUTFILE); rewrite(f);
	writeln(f, rjesenje);
	close(f);
end;

begin
	load_data;
        solve;
	write_solution;
end.
