
/*
Izborne pripreme 2002, Prvi izborni ispit
Zadatak SVINJE, Programski jezik C
*/

#include <stdio.h>

#define IN_FILE      "SVINJE.IN"
#define OUT_FILE     "SVINJE.OUT"
#define MAX_LJUDI    100 + 2
#define MAX_SVINJACA 10000
#define INTINF       1000000000

int broj_svinjaca, broj_ljudi;
int svinjac[MAX_SVINJACA];
int kljuceva[MAX_LJUDI];
int kljuc[MAX_LJUDI][MAX_SVINJACA];
int koliko_treba[MAX_LJUDI];

int deg[MAX_LJUDI];
int adj[MAX_LJUDI][MAX_LJUDI];
int tezina[MAX_LJUDI][MAX_LJUDI];

int svinja[MAX_LJUDI];

int rjesenje;

void read_inputs()
{
	FILE *fp;
	int i, j;

	fp = fopen(IN_FILE, "r");

	fscanf(fp, "%d%d", &broj_svinjaca, &broj_ljudi);

	for(i = 0; i < broj_svinjaca; i++)
		fscanf(fp, "%d", &svinjac[i]);

	for(i = 0; i < broj_ljudi; i++)
	{
		fscanf(fp, "%d", &kljuceva[i]);
		for(j = 0; j < kljuceva[i]; j++)
		{
			fscanf(fp, "%d", &kljuc[i][j]);
			kljuc[i][j]--;
		}

		fscanf(fp, "%d", &koliko_treba[i]);
	}

	fclose(fp);
}

void init_graph()
{
	int i, j, ki, kj;

	for(i = 0; i < broj_ljudi - 1; i++)
		for(j = i + 1; j < broj_ljudi; j++)
			for(ki = kj = 0; ki < kljuceva[i] && kj < kljuceva[j]; )
				if(kljuc[i][ki] == kljuc[j][kj])
				{
					adj[i][deg[i]++] = j;
					break;
				}
				else if(kljuc[i][ki] < kljuc[j][kj])
					ki++;
				else
					kj++;
}

void init_svinje()
{
	int was[MAX_SVINJACA] = {0};
	int i, j;

	for(i = 0; i < broj_ljudi; i++)
	{
		svinja[i] = -koliko_treba[i];
		for(j = 0; j < kljuceva[i]; j++)
			if(!was[kljuc[i][j]])
			{
				was[kljuc[i][j]] = 1;
				svinja[i] += svinjac[kljuc[i][j]];
			}

		rjesenje += koliko_treba[i];
		if(svinja[i] < 0)
			rjesenje += svinja[i];
	}
}

void finish_graph()
{
	int source, sink;
	int i, j;

        source = broj_ljudi;
        sink = broj_ljudi + 1;

	for(i = 0; i < broj_ljudi; i++)
	{
		for(j = 0; j < deg[i]; j++)
			tezina[i][adj[i][j]] = INTINF;

		if(svinja[i] > 0)
		{
			adj[source][deg[source]++] = i;
			tezina[source][i] = svinja[i];
		}
		else if(svinja[i] < 0)
		{
			adj[i][deg[i]++] = sink;
			tezina[i][sink] = -svinja[i];
		}
	}

	for(i = 0; i < broj_ljudi; i++)
		for(j = 0; j < deg[i]; j++)
			adj[adj[i][j]][deg[adj[i][j]]++] = i;
}

int find_path(int dad[])
{
	int head, tail, q[MAX_LJUDI];
	int source, sink;
	int was[MAX_LJUDI] = {0};
	int v, i;

	source = broj_ljudi;
	sink = broj_ljudi + 1;

	head = tail = 0;

	q[tail++] = source;
	was[source] = 1;
	do {
		v = q[head++];
		if(v == sink) return 1;

		for(i = 0; i < deg[v]; i++)
			if(tezina[v][adj[v][i]] > 0 && !was[adj[v][i]])
			{
				q[tail++] = adj[v][i];
				was[adj[v][i]] = 1;
				dad[adj[v][i]] = v;
			}
	} while(head != tail);

	return 0;
}

int NAPOKON_FORD_FULKERSON_MAXIMUM_NETWORK_FLOW()
{
	int source, sink;
	int dad[MAX_LJUDI];
	int min;
	int i;

	source = broj_ljudi;
	sink = broj_ljudi + 1;

	if(!find_path(dad)) return 0;

	min = INTINF;
	for(i = sink; i != source; i = dad[i])
		if(tezina[dad[i]][i] < min)
			min = tezina[dad[i]][i];

	for(i = sink; i != source; i = dad[i])
	{
		tezina[dad[i]][i] -= min;
		tezina[i][dad[i]] += min;
	}

	rjesenje += min;

	return 1;
}

void write_sol()
{
	FILE *fp;

	fp = fopen(OUT_FILE, "w");

	fprintf(fp, "%d\n", rjesenje);

	fclose(fp);
}

int main()
{
	read_inputs();
	init_graph();
	init_svinje();
	finish_graph();
	while(NAPOKON_FORD_FULKERSON_MAXIMUM_NETWORK_FLOW());
	write_sol();

	return 0;
}
