
(*
Izborne pripreme 2002, Prvi izborni ispit
Zadatak SVINJE, Programski jezik Pascal
*)

const IN_FILE = 'SVINJE.IN';
const OUT_FILE = 'SVINJE.OUT';
const MAX_LJUDI = 102;
const MAX_SVINJACA = 10000;
const INTINF = 1000000000;

var broj_svinjaca, broj_ljudi : longint;
    svinjac : array[0..MAX_SVINJACA-1] of longint;
    kljuceva : array[0..MAX_LJUDI-1] of longint;
    kljuc : array[0..MAX_LJUDI-1, 0..MAX_SVINJACA-1] of longint;
    koliko_treba : array[0..MAX_LJUDI-1] of longint;
    deg : array[0..MAX_LJUDI-1] of longint;
    adj : array[0..MAX_LJUDI-1, 0..MAX_LJUDI-1] of longint;
    tezina : array[0..MAX_LJUDI-1, 0..MAX_LJUDI-1] of longint;
    svinja : array[0..MAX_LJUDI-1] of longint;
    rjesenje : longint;
    dad : array[0..MAX_LJUDI-1] of longint;

procedure read_inputs;
var fp : text;
    i, j : longint;
begin
	assign(fp, IN_FILE);
	reset(fp);
	read(fp, broj_svinjaca, broj_ljudi);
	for i := 0 to broj_svinjaca-1 do read(fp, svinjac[i]);
	for i := 0 to broj_ljudi-1 do begin
		read(fp, kljuceva[i]);
		for j := 0 to kljuceva[i]-1 do begin
			read(fp, kljuc[i,j]);
			kljuc[i, j] := kljuc[i, j] - 1;
			end;
		read(fp, koliko_treba[i]);
	end;
	close(fp);
end;

procedure init_graph;
var i, j, ki, kj : longint;
begin
	for i := 0 to broj_ljudi - 2 do
		for j := i + 1 to broj_ljudi - 1 do  begin
		ki := 0;
		kj := 0;
    while (ki < kljuceva[i]) and (kj < kljuceva[j]) do if (kljuc[i, ki] = kljuc[j, kj]) then begin
			adj[i, deg[i]] := j;
			deg[i] := deg[i] + 1;
			break;
      end else if (kljuc[i, ki] < kljuc[j, kj]) then ki := ki + 1 else kj := kj + 1;

                end;
end;

procedure init_svinje;
var was : array[0..MAX_SVINJACA-1] of longint;
    i, j : longint;
begin
	for i := 0 to MAX_SVINJACA-1 do was[i] := 0;

	for i := 0 to broj_ljudi-1 do begin
		svinja[i] := -koliko_treba[i];
		for j := 0 to kljuceva[i] - 1 do if (was[kljuc[i, j]] = 0) then begin
		was[kljuc[i, j]] := 1;
		svinja[i] := svinja[i] + svinjac[kljuc[i, j]];
		end;
		rjesenje := rjesenje + koliko_treba[i];
    if (svinja[i] < 0) then rjesenje := rjesenje + svinja[i];
	end;
end;

procedure finish_graph;
var source, sink, i, j : longint;
begin
	source := broj_ljudi;
	sink := broj_ljudi + 1;
	for i := 0 to broj_ljudi - 1 do begin
		for j := 0 to deg[i] - 1 do tezina[i, adj[i, j]] := INTINF;
    if (svinja[i] > 0) then begin
			adj[source, deg[source]] := i;
			deg[source] := deg[source] + 1;
			tezina[source, i] := svinja[i];
    end else if (svinja[i] < 0) then begin
			adj[i, deg[i]] := sink;
			deg[i] := deg[i] + 1;
			tezina[i, sink] := -svinja[i];
		end;
	end;
        i := 0;
        while (i < broj_ljudi) do begin
            j := 0;
            while (j < deg[i]) do begin
		adj[adj[i, j], deg[adj[i, j]]] := i;
		deg[adj[i, j]] := deg[adj[i, j]] + 1;
                        j := j + 1;
            end;
            i := i + 1
        end;
end;

function find_path : longint;
var v, i, head, tail, source, sink : longint;
    q, was : array[0..MAX_LJUDI-1] of longint;
begin
	for i := 0 to MAX_LJUDI - 1 do was[i] := 0;
	source := broj_ljudi;
	sink := broj_ljudi + 1;
	head := 0;
	tail := 0;
	q[tail] := source;
	tail := tail + 1;
	was[source] := 1;
	repeat
		v := q[head];
		head := head + 1;
		if (v = sink) then begin
			find_path := 1;
			exit;
		end;


		i := 0;
                while (i < deg[v]) do begin

{   for i := 0 to deg[v] - 1 do} if (tezina[v, adj[v, i]] > 0) and (was[adj[v, i]] = 0) then begin
			q[tail] := adj[v, i];
			tail := tail + 1;
			was[adj[v, i]] := 1;
			dad[adj[v, i]] := v;
		end;
                i := i + 1;
                end;
	until head = tail;
	find_path := 0;
end;

function ford_fulkerson_maximum_network_flow : longint;
var source, sink, i, min : longint;
begin
	source := broj_ljudi;
	sink := broj_ljudi + 1;
	if (find_path = 0) then begin
		ford_fulkerson_maximum_network_flow := 0;
		exit;
	end;
	min := INTINF;
	i := sink;
  while (i <> source) do begin
    if (tezina[dad[i], i] < min) then min := tezina[dad[i], i];
		i := dad[i];
	end;

	i := sink;
  while (i <> source) do begin
		tezina[dad[i], i] := tezina[dad[i], i] - min;
		tezina[i, dad[i]] := tezina[i, dad[i]] + min;
		i := dad[i];
	end;
	rjesenje := rjesenje + min;
	ford_fulkerson_maximum_network_flow := 1;
end;

procedure write_sol;
var fp : text;
begin
	assign(fp, OUT_FILE);
	rewrite(fp);
	writeln(fp, rjesenje);
	close(fp);
end;
begin
	read_inputs;
	init_graph;
	init_svinje;
	finish_graph;
  while (ford_fulkerson_maximum_network_flow <> 0) do;
	write_sol;
end.
