
/*
Izborne pripreme 2003, Drugi izborni ispit
Zadatak TRGOVAC, Programski jezik C
*/

#include <stdio.h>
#include "trgovac.h"

#define MAXGRADOVA		1000

int broj_gradova;
int rjesenje[MAXGRADOVA];

void solve ( void )
{
	int odgovor, left, right, mid, i, grad;

	// prvo stavljamo gradove 1 i 2 u listu
	odgovor=Pitaj (1, 2);
	if (odgovor==1)
	{
		// strelica ide iz 1-->2
		rjesenje[0]=1; rjesenje[1]=2;
	}
	else
	{
		// strelica ide iz 2-->1
		rjesenje[0]=2; rjesenje[1]=1;
	}

	// i sada redom dodajemo gradove binary searchom
	for (grad=3; grad<=broj_gradova; grad++)
	{
		// prvo provjera za gradove koji su trenutno na rubu
		odgovor=Pitaj (grad, rjesenje[0]);
		if (odgovor == grad)
		{
			// znaci strelica ide grad-->rjesenje[0], tj.
			// grad moze biti novi pocetak liste
			for (i=grad-1; i>0; i--)
				rjesenje[i]=rjesenje[i-1];
			rjesenje[0]=grad;
			continue;
		}

		odgovor=Pitaj (grad, rjesenje[grad-2]);
		if (odgovor == rjesenje[grad-2])
		{
			// znaci strelica ide rjesenje[grad-2]-->grad, tj.
			// grad moze biti novi kraj liste
			rjesenje[grad-1]=grad;
			continue;
		}

		// dakle strelice zasad idu ovako:
		// rjesenje[0] --> grad i grad-->rjesenje[grad-2]
		// binary searchom trazimo 2 uzastopna grada x i y t.d.
		// x-->grad-->y  (x i y imaju uzastone indexe u rjesenje)
		left=0; right=grad-2;
		while (right-left > 1)
		{
			mid=(left+right)/2;
			odgovor=Pitaj (grad, rjesenje[mid]);
			if (odgovor == grad)
			{
				// strelice idu rjesenje[0]-->grad-->rjesenje[mid]
				right=mid;
			}
			else
			{
				// strelica ide rjesenje[mid]-->grad-->rjesenje[grad-2]
				left=mid;
			}
		}

		// gradovi rjesenje[left] i rjesenje[right] su x i y
		// sad samo uguraj grad izmedju njih u listu
		for (i=grad-1; i>left; i--)
			rjesenje[i]=rjesenje[i-1];
		rjesenje[left+1]=grad;
	}
}

int main ( void )
{
	broj_gradova=Init();
	solve();
	Gotovo (rjesenje-1);

	return 0;
}
