
/*
Izborne pripreme 2003, Drugi izborni ispit
Zadatak VOKITOKI, Programski jezik C++
*/

#include <complex>
#include <cstdio>
#include <list>
#include <vector>

#define ZERO 0.000001

using namespace std;

double d;
struct point { int x, y; };
struct edge { int u, v; };
int s1, s2;
vector< point > V;
vector< edge > E;
vector< vector< bool > > visited;
vector< bool > can_visit;
vector< list< int > > adj;
typedef list< int >::iterator LI;

void input() {
   int i, j, n, p;
   int a, b, x, y;
   scanf( "%d%d%lf", &n, &p, &d );
   d += ZERO;

   adj.resize( n );
   can_visit.resize( n );
   for( i = 0; i < n; ++i ) can_visit[i] = false;

   for( i = 0; i < n; ++i ) {
      scanf( "%d%d", &x, &y );
      V.push_back( (point) { x, y } );
   }
   for( i = 0; i < p; ++i ) {
      scanf( "%d%d", &a, &b ); a--; b--;
      E.push_back( (edge) { a, b } );
      adj[a].push_back( i );
      adj[b].push_back( i );
   }
   scanf( "%d%d", &s1, &s2 ); s1--; s2--;
   E.push_back( (edge) { s1, s1 } );
   E.push_back( (edge) { s2, s2 } );

   visited.resize( E.size() );
   for( i = 0; i < E.size(); ++i ) {
      visited[i].resize( i );
      for( j = 0; j < E.size(); ++j )
         visited[i][j] = false;
   }
}

double triangle_area( double a, double b, double c ) {
   double s = (a+b+c) / 2;
   return sqrt( s * (s-a) * (s-b) * (s-c) );
}

double dist_line_from_point( point &a, point &b, point &c ) {
   double x = hypot( a.x - c.x, a.y - c.y );
   double y = hypot( b.x - c.x, b.y - c.y );
   double z = hypot( a.x - b.x, a.y - b.y );
   if( y*y >= x*x + z*z ) return x;
   if( x*x >= y*y + z*z ) return y;
   return 2 * triangle_area( x, y, z ) / z;
}

void dfs( int a, int b ) {
   if( visited[a][b] ) return;
   visited[a][b] = true;
   if( dist_line_from_point( V[E[a].u], V[E[a].v], V[E[b].u] ) <= d ) {
      can_visit[E[b].u] = true;
      for( LI i = adj[E[b].u].begin(); i != adj[E[b].u].end(); ++i )
         dfs( a, (*i) );
   }
   if( dist_line_from_point( V[E[a].u], V[E[a].v], V[E[b].v] ) <= d ) {
      can_visit[E[b].v] = true;
      for( LI i = adj[E[b].v].begin(); i != adj[E[b].v].end(); ++i )
         dfs( a, (*i) );
   }
   if( dist_line_from_point( V[E[b].u], V[E[b].v], V[E[a].u] ) <= d )
      for( LI i = adj[E[a].u].begin(); i != adj[E[a].u].end(); ++i )
         dfs( (*i), b );
   if( dist_line_from_point( V[E[b].u], V[E[b].v], V[E[a].v] ) <= d )
      for( LI i = adj[E[a].v].begin(); i != adj[E[a].v].end(); ++i )
         dfs( (*i), b );
}

void output() {
   int i;
   for( i = 0; i < can_visit.size(); ++i )
      if( can_visit[i] )
         printf( "%d\n", i+1 );
}

int main( void ) {
   freopen( "vokitoki.in", "rt", stdin );
   freopen( "vokitoki.out", "wt", stdout );

   input();
   dfs( E.size() - 2, E.size() - 1 );
   output();

   fclose( stdout );
   fclose( stdin );
   return 0;
}
