
(*
Izborne pripreme 2003, Drugi izborni ispit
Zadatak VOKITOKI, Programski jezik Pascal
*)

program vokitoki;

const MAXV = 150;
const MAXE = 500;
const NULA = 0.000001;

type tocka  = record x, y       : longint; end;
     duzina = record a, b, broj : longint; end;
var
    n, m             : longint;
    start_a, start_b : longint;
    domet            : double;
    brid             : array[0..MAXV  , 0..MAXV  ] of longint;
    bio              : array[0..MAXE+1, 0..MAXE+1] of boolean;
    slavko_bio       : array[0..MAXV             ] of boolean;
    p                : array[0..MAXV             ] of tocka;
    e                : array[0..MAXV             ] of duzina;

procedure input;
var i : longint;
    f : text;
begin
   assign(f, 'vokitoki.in');
   reset(f);
   readln(f, n, m, domet);
   for i:=0 to n-1 do readln(f, p[i].x, p[i].y);
   inc(m);
   for i:=1 to m-1 do
   begin
      readln(f, e[i].a, e[i].b); dec(e[i].a); dec(e[i].b);
      brid[e[i].b, e[i].a] := i;
      brid[e[i].a, e[i].b] := i;
      e[i].broj := i;
   end;
   readln(f, start_a, start_b); dec(start_a); dec(start_b);

   e[m].a := start_a; e[m].b := start_a; e[m].broj := m; inc(m);
   e[m].a := start_b; e[m].b := start_b; e[m].broj := m; inc(m);

   domet := domet + NULA;
   close(f);
end;

function udaljenost_tocke_od_tocke(t1, t2 : tocka) : double;
begin
   udaljenost_tocke_od_tocke:=sqrt( (t1.x - t2.x) * (t1.x - t2.x) +
                                    (t1.y - t2.y) * (t1.y - t2.y) );
end;


function povrsina_trokuta(x, y, z : double) : double;
var s : double;
begin
   s := (x + y + z) / 2;
   povrsina_trokuta := sqrt( s * (s - x) * (s - y) * (s - z) );
end;

function udaljenost_tocke_od_duzine(t : tocka; d : duzina) : double;
var x, y, z, r : double;
begin
   x := udaljenost_tocke_od_tocke( t, p[d.a] );
   y := udaljenost_tocke_od_tocke( t, p[d.b] );
   z := udaljenost_tocke_od_tocke( p[d.a], p[d.b] );
   if x*x >= y*y + z*z then r:=y else
   if y*y >= x*x + z*z then r:=x else
   r := 2 * povrsina_trokuta( x, y, z) / z;
   udaljenost_tocke_od_duzine := r;
end;

procedure dfs(x, y : duzina);
var i : longint;
begin
   if bio[x.broj, y.broj] then exit;
   bio[x.broj, y.broj] := true;

   if udaljenost_tocke_od_duzine( p[x.a], y ) <= domet then
      for i := 0 to n-1 do
         if brid[x.a, i]<>0 then
            dfs( e[brid[x.a, i]], y );

   if udaljenost_tocke_od_duzine( p[x.b], y ) <= domet then
      for i := 0 to n-1 do
         if brid[x.b, i]<>0 then
            dfs( e[brid[x.b, i]], y );

   if udaljenost_tocke_od_duzine( p[y.a], x ) <= domet then
   begin
      slavko_bio[y.a] := true;
      for i := 0 to n-1 do
         if brid[i, y.a]<>0 then
            dfs( x, e[brid[i, y.a]] );
   end;

   if udaljenost_tocke_od_duzine( p[y.b], x ) <= domet then
   begin
      slavko_bio[y.b] := true;
      for i := 0 to n-1 do
         if brid[i, y.b]<>0 then
            dfs( x, e[brid[i, y.b]] );
   end;
end;

procedure ispis;
var i : longint;
    f : text;
begin
   assign(f, 'vokitoki.out');
   rewrite(f);
   for  i := 0 to n-1 do
      if slavko_bio[i] then writeln(f, i + 1);
   close(f);
end;

begin
   input;
   slavko_bio[start_b] := true;
   dfs( e[m-2], e[m-1] );
   ispis;
end.
