
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define INFILE			"trgovac.in"
#define OUTFILE			"trgovac.out"
#define LOGFILE			"trgovac.log"
#define MAXGRADOVA		1000
#define MAXPITANJA		10000

#define PREVISE_PITANJA		-1
#define ILEGALNO_PITANJE	-2

static int broj_gradova;
static int strelica[MAXGRADOVA][MAXGRADOVA];
static FILE *flog;
static int broj_pitanja=0, muljaza=0;

// za muljazu
static int maxin[MAXGRADOVA+1], maxout[MAXGRADOVA+1];
static int bio[MAXGRADOVA][MAXGRADOVA];

int Init ( void )
{
	FILE *fin;
	int i, j;

	flog=fopen (LOGFILE, "wt");
	
	if (!(fin=fopen (INFILE, "rt")))
	{
		fprintf (flog, "Datoteka %s ne postoji.\n", INFILE);
		fclose (flog);
		exit(0);
	}

	/* ucitavamo podatke iz trgovac.in */
	if (fscanf (fin, "%d", &broj_gradova) != 1)
	{
		fprintf (flog, "Format datoteke %s nije dobar.\n", INFILE);
		fclose (flog);
		exit(0);
	}

	for (i=0; i<broj_gradova; i++)
		for (j=i+1; j<broj_gradova; j++)
		{
			if (fscanf (fin, "%d", &strelica[i][j]) != 1)
			{
				fprintf (flog, "Format datoteke %s nije dobar.\n", INFILE);
				fclose (flog);
				exit(0);
			}
			else strelica[i][j]--;

			if (strelica[0][1] == -1)
			{
				muljaza=1;
				goto van;
			}

			strelica[j][i]=strelica[i][j];
		}
			
van:;
	fclose (fin);
		
	return broj_gradova;
}

int muljaj (int grad1, int grad2)
{
	// jel sam vec odgovorio na to pitanje
	if (bio[grad1][grad2])
		return strelica[grad1][grad2];

	// pogledaj jel bolje staviti strelicu grad1->grad2 ili obratno

	if (maxin[grad1]+maxout[grad2] > maxin[grad2]+maxout[grad1])
	{
		// bolje je grad2->grad1
		if (maxout[grad2] < maxout[grad1]+1)
			maxout[grad2]=maxout[grad1]+1;

		if (maxin[grad1] < maxin[grad2]+1)
			maxin[grad1]=maxin[grad2]+1;

		strelica[grad1][grad2]=strelica[grad2][grad1]=grad2;
	}
	else
	{
		// bolje je grad1->grad2
		if (maxout[grad1] < maxout[grad2]+1)
			maxout[grad1]=maxout[grad2]+1;

		if (maxin[grad2] < maxin[grad1]+1)
			maxin[grad2]=maxin[grad1]+1;

		strelica[grad1][grad2]=strelica[grad2][grad1]=grad1;
	}

	bio[grad1][grad2]=bio[grad2][grad1]=1;
	return strelica[grad1][grad2];
}

int Pitaj (int grad1, int grad2)
{
	broj_pitanja++;

	if (broj_pitanja > MAXPITANJA)
	{
		FILE *fout;
		
		fprintf (flog, "Prevelik broj pitanja.\n");
		fout=fopen (OUTFILE, "wt");
		fprintf (fout, "%d\n", PREVISE_PITANJA);
		fclose (fout);
		fclose (flog);

		exit (0);
	}
	
	fprintf (flog, "Pitanje broj %d: Pitaj(%d, %d) --> ",
					broj_pitanja, grad1, grad2);

	if (grad1==grad2 || 1>grad1 || 1>grad2 || grad1>broj_gradova || grad2>broj_gradova)
	{
		FILE *fout=fopen (OUTFILE, "wt");
		
		fprintf (flog, "nedozvoljeno pitanje\n");
		fclose (flog);

		fprintf (fout, "%d\n", ILEGALNO_PITANJE);
		fclose (fout);
		
		exit (0);
	}						
	else
	{
		int odg;
		
		if (muljaza)
			odg=muljaj(grad1-1, grad2-1);
		else
			odg=strelica[grad1-1][grad2-1];

		fprintf (flog, "%d\n", strelica[grad1-1][grad2-1]+1);
		return odg+1;
	}
}

void napravi_in_file ( void )
{
	FILE *fin=fopen (INFILE, "wt");
	int i, j;

	srand(time(0));
	fprintf (fin, "%d\n", broj_gradova);
	for (i=0; i<broj_gradova-1; i++)
	{
		for (j=i+1; j<broj_gradova; j++)
		{
			if (bio[i][j])
				fprintf (fin, "%d ", strelica[i][j]+1);
			else
				fprintf (fin, "%d ", (j-i)*(rand()%2)+i+1);
		}

		fprintf (fin, "\n");
	}

	fclose (fin);
}

void Gotovo (int *put)
{
	FILE *fout;
	int i;

	fprintf (flog, "Ukupno postavljeno %d pitanja.\n", broj_pitanja);
	fclose (flog);

	fout=fopen (OUTFILE, "wt");
	fprintf (fout, "%d\n", broj_pitanja);

	// pazi, ovdje je put indexiran od jedan!!!!!
	fprintf (fout, "%d", put[1]);
	for (i=2; i<=broj_gradova; i++)
		fprintf (fout, " %d", put[i]);

	fprintf (fout, "\n");
	fclose (fout);

	// ako muljam onda moram napraviti i in-file za checker
	if (muljaza)
		napravi_in_file();

	exit (0);
}
