
#include <stdio.h>
#include <stdlib.h>

#define INFILE			"trgovac.in"
#define OUTFILE			"trgovac.out"
#define LOGFILE			"trgovac.log"
#define MAXGRADOVA		1000
#define MAXPITANJA		10000

#define PREVISE_PITANJA		-1
#define ILEGALNO_PITANJE	-2

static int broj_gradova;
static int strelica[MAXGRADOVA][MAXGRADOVA];
static FILE *flog;
static int broj_pitanja=0;

int Init ( void )
{
	FILE *fin;
	int i, j;

	flog=fopen (LOGFILE, "wt");
	
	if (!(fin=fopen (INFILE, "rt")))
	{
		fprintf (flog, "Datoteka %s ne postoji.\n", INFILE);
		fclose (flog);
		exit(0);
	}

	/* ucitavamo podatke iz trgovac.in */
	if (fscanf (fin, "%d", &broj_gradova) != 1)
	{
		fprintf (flog, "Format datoteke %s nije dobar.\n", INFILE);
		fclose (flog);
		exit(0);
	}

	for (i=0; i<broj_gradova; i++)
		for (j=i+1; j<broj_gradova; j++)
		{
			if (fscanf (fin, "%d", &strelica[i][j]) != 1)
			{
				fprintf (flog, "Format datoteke %s nije dobar.\n", INFILE);
				fclose (flog);
				exit(0);
			}
			else strelica[i][j]--;

			strelica[j][i]=strelica[i][j];
		}
			
	fclose (fin);
		
	return broj_gradova;
}

int Pitaj (int grad1, int grad2)
{
	broj_pitanja++;

	if (broj_pitanja > MAXPITANJA)
	{
		FILE *fout;
	
		fprintf (flog, "Prevelik broj pitanja.\n");
		fout=fopen (OUTFILE, "wt");
		fprintf (fout, "%d\n", PREVISE_PITANJA);
		fclose (fout);
		fclose (flog);

		exit (0);
	}
	
	fprintf (flog, "Pitanje broj %d: Pitaj(%d, %d) --> ",
					broj_pitanja, grad1, grad2);

	if (grad1==grad2 || 1>grad1 || 1>grad2 || grad1>broj_gradova || grad2>broj_gradova)
	{
		FILE *fout=fopen (OUTFILE, "wt");
		
		fprintf (flog, "nedozvoljeno pitanje\n");
		fclose (flog);

		fprintf (fout, "%d\n", ILEGALNO_PITANJE);
		fclose (fout);
		
		exit (0);
	}						
	else
	{
		fprintf (flog, "%d\n", strelica[grad1-1][grad2-1]+1);
		return strelica[grad1-1][grad2-1]+1;
	}
}

void Gotovo (int *put)
{
	FILE *fout;
	int i;

	fprintf (flog, "Ukupno postavljeno %d pitanja.\n", broj_pitanja);
	fclose (flog);

	fout=fopen (OUTFILE, "wt");
	fprintf (fout, "%d\n", broj_pitanja);

	// pazi, ovdje je put indexiran od jedan!!!!!
	fprintf (fout, "%d", put[1]);
	for (i=2; i<=broj_gradova; i++)
		fprintf (fout, " %d", put[i]);

	fprintf (fout, "\n");
	fclose (fout);

	exit (0);
}
