
/*
Izborne pripreme 2003, Prvi izborni ispit
Zadatak JOZO, Programski jezik C++
*/

#include <cstdio>
#include <iostream>
#include <queue>
#include <vector>

#define INF 1000000

using namespace std;

class veza {
   public:
   int u, v, kada;
   friend bool operator < ( const veza &a, const veza &b ) {
      return a.kada > b.kada;
   }
};

class moditerator {
   public:
   int val, max;
   moditerator( int m ) { max = m; }
   int operator * () { return val; }
   moditerator & operator = ( int x ) { val = x; return *this; }
   moditerator & operator ++ () { if( ++val == max ) val = 0; return *this; }
   friend moditerator operator - ( const moditerator &a, int x ) {
      moditerator t( a.max );
      t.val = a.val - x;
      if( t.val < 0 ) t.val += t.max;
      return t;
   }
};

vector< vector< int > > opt;
vector< vector< int > > graf;
priority_queue< veza > veze;

int n, t1, t2;

void input() {
   int i, j, m, V, u, v, t;
   scanf( "%d%d%d%d%d", &n, &m, &V, &t1, &t2 );

   graf.resize( n );
   for( i = 0; i < n; ++i ) {
      graf[i].resize( n );
      for( j = 0; j < n; ++j ) graf[i][j] = INF;
   }
   for( i = 0; i < m; ++i ) {
      scanf( "%d%d%d", &u, &v, &t ); u--; v--;
      graf[u][v] = graf[v][u] = t;
   }
   for( i = 0; i < V; ++i ) {
      scanf( "%d%d%d", &t, &m, &u ); u--;
      for( j = 1; j < m; ++j ) {
         scanf( "%d", &v ); v--;
         t += graf[u][v];
         veze.push( (veza) { u, v, t } );
         u = v;
      }
   }
   veze.push( (veza) { 0, 0, INF } );
}

int solve() {
   int i, j;
   int t, rez = INF;
   veza tmp;
   moditerator x( 601 ), y( 601 );

   opt.resize( 601 );
   for( i = 0; i <= 600; ++i ) {
      opt[i].resize( n );
      for( j = 0; j < n; ++j ) opt[i][j] = INF;
   }
   opt[1][0] = 0;

   x = 1;
   for( t = 2; t <= t2; ++t ) {
      ++x; y = x-1;
      for( i = 0; i < n; ++i )
         opt[*x][i] = opt[*y][i] + 1;

      for( ; veze.top().kada == t; veze.pop() ) {
         tmp = veze.top();
         opt[*x][tmp.v] <?= opt[ *(x-graf[tmp.u][tmp.v]) ][tmp.u];
      }
      if( t >= t1 ) rez <?= opt[*x][0];
   }
   return rez;
}

int main( void ) {
   freopen( "jozo.in", "rt", stdin );
   freopen( "jozo.out", "wt", stdout );

   input();
   cout << solve() << endl;

   fclose( stdin );
   fclose( stdout );
   return 0;
}
