
(*
Izborne pripreme 2003, Prvi izborni ispit
Zadatak JOZO, Programski jezik Pascal
*)

const MAXN = 1000;
const MAXV = 1000;

type brid = record
   u, v: longint;
   kada: longint;
end;

var
   f:text;
   n, p, vv, t1, t2: longint;
   time: array[1..MAXN, 1..MAXN] of longint;
   E: array[1..MAXN*MAXV] of brid;
   nE: longint;
   min: array[1..MAXN, 0..601] of longint;

procedure qsort( l, r: longint );
var
   i, j, x: longint;
   t: brid;
begin
   i := l;
   j := r;
   x := E[(l+r) div 2].kada;
   repeat
      while E[i].kada < x do i := i + 1;
      while x < E[j].kada do j := j - 1;
      if i <= j then
      begin
         t := E[i]; E[i] := E[j]; E[j] := t;
         i := i + 1;
         j := j - 1;
      end;
   until i > j;
   if l < j then qsort( l, j );
   if i < r then qsort( i, r );
end;

procedure input;
var
   i, j: longint;
   s1, s2, t: longint;
   t0, ns, u, v: longint;
begin
   assign( f, 'jozo.in' );
   reset( f );

   readln( f, n, p, vv, t1, t2 );
   for i := 1 to p do
   begin
      readln( f, s1, s2, t );
      time[s1, s2] := t;
      time[s2, s1] := t;
   end;

   for i := 1 to vv do
   begin
      read( f, t0, ns, v );
      for j := 2 to ns do
      begin
         u := v;
         read( f, v );
         t0 := t0 + time[u][v];
         nE := nE + 1;
         E[nE].u := u;
         E[nE].v := v;
         E[nE].kada := t0;
      end;
   end;

   qsort( 1, nE );

   close( f );
end;

function solve: longint;
var
   i, j, t: longint;
   x, y: longint;
   rez: longint;
begin
   i := 1;
   rez := 1000000;
   for j := 1 to n do min[j, 1] := 1000000;
   min[1, 1] := 0;

   for t := 2 to t2 do
   begin
      x := t mod 601; y := (t + 601 - 1) mod 601;
      for j := 1 to n do
      begin
         min[j, x] := min[j, y] + 1;
      end;

      while (i <= nE) and (E[i].kada = t) do
      begin
         y := (t + 601 - time[E[i].u, E[i].v]) mod 601;
         if min[E[i].u, y] <  min[E[i].v, x] then
            min[E[i].v, x] := min[E[i].u, y];
         i := i + 1;
      end;

      if (t >= t1) and (min[1, x] < rez) then rez := min[1, x];
   end;
   solve := rez;
end;

begin
   input;
   assign( f, 'jozo.out' );
   rewrite( f );
   writeln( f, solve );
   close( f );
end.
