
/*
Izborne pripreme 2003, Prvi izborni ispit
Zadatak LIST, Programski jezik C++
*/

#include <fstream>
#include <set>
#include <algorithm>

#define INFILE                  "list.in"
#define OUTFILE                 "list.out"
#define MAXVRHOVA		100000

using namespace std;

int kod[MAXVRHOVA+1], zadnja_pojava[MAXVRHOVA+1], broj_vrhova;
pair<int, int> brid[MAXVRHOVA+1];

void load_data ( void )
{
	ifstream fin(INFILE);

	fin >> broj_vrhova;

	int i;
	for (i=1; i<broj_vrhova; i++)
	{
		fin >> kod[i];
		zadnja_pojava[kod[i]]=i;
	}

	fin.close();
}

void solve ( void )
{
	// prvo pogledaj sve vrhove koji se ne javljaju u kodu -- to je lisce
	set<int> lisce;

	int i, list;
	for (i=1; i<=broj_vrhova; i++)
		if (zadnja_pojava[i]==0)
			lisce.insert (i);

	for (i=1; i<broj_vrhova; i++)
	{
		// idemo vrh po vrh u kodu
		// trenutno najmanji list je onaj kojeg smo sad uklonili, tj.
		// onaj ciji je susjed kod[i] -- dodaj to u graf
		list=*(lisce.begin());
		brid[i].first=list; brid[i].second=kod[i];

		// u ovom trenutku iz stabla je bio uklonjen list list
		lisce.erase (list);

		// mozda je kod[i] postao list
		if (zadnja_pojava[kod[i]] == i)
			lisce.insert (kod[i]);

		// i sad sve ponovi sa ovim stablom
	}
}

void write_solution ( void )
{
	ofstream fout(OUTFILE);
	int i;

	for (i=1; i<broj_vrhova; i++)
		fout << brid[i].first << " " << brid[i].second << endl;

	fout.close();
}

int main ( void )
{
	load_data();
	solve();
	write_solution();

	return 0;
}
