
/*
Izborne pripreme 2004 - Drugi izborni ispit
Zadatak TETRIS
*/

#include <iostream>
#include <map>

using namespace std;

char a[7*4][6*4] = { "X.. .X. ..X ,,, ,,, ,,,",
                     "X.. .X. ..X ,,, ,,, ,,,",
                     "X.. .X. ..X ,,, ,,, ,,,",
                     "X.. .X. ..X ,,, ,,, ,,,",
                     "... ... ... ... ... ...",
                     "XX. .XX .X. ..X ... ...",
                     "X.. .X. .X. ..X X.. XXX",
                     "X.. .X. XX. .XX XXX ..X",
                     "... ... ... ... ... ...",
                     "XX. .XX X.. .X. ... ...",
                     ".X. ..X X.. .X. ..X XXX",
                     ".X. ..X XX. .XX XXX X..",
                     "... ... ... ... ... ...",
                     "X.. .X. .X. ..X ... ...",
                     "XX. .XX XX. .XX .X. XXX",
                     "X.. .X. .X. ..X XXX .X.",
                     "... ... ... ,,, ,,, ,,,",
                     "... X.. .X. ,,, ,,, ,,,",
                     ".XX XX. .XX ,,, ,,, ,,,",
                     "XX. .X. ..X ,,, ,,, ,,,",
                     "... ... ... ,,, ,,, ,,,",
                     "... .X. ..X ,,, ,,, ,,,",
                     "XX. XX. .XX ,,, ,,, ,,,",
                     ".XX X.. .X. ,,, ,,, ,,,",
                     "... ... ,,, ,,, ,,, ,,,",
                     "... ... ,,, ,,, ,,, ,,,",
                     "XX. .XX ,,, ,,, ,,, ,,,",
                     "XX. .XX ,,, ,,, ,,, ,,," };

int b[7][6][3][2];

void init() {
  for( int i = 0; i < 7; ++i )
    for( int j = 0; j < 6; ++j )
      for( int k = 0; k < 3; ++k ) {
        int x, y;
        for( x = 0; x < 4; ++x ) if( a[i*4 + 3-x][j*4 + k] != '.' ) break;
        for( y = 4; y > 0; --y ) if( a[i*4 + 4-y][j*4 + k] != '.' ) break;

        b[i][j][k][0] = x;
        b[i][j][k][1] = y;
      }
}

struct stanje {
  int i, s1, s2, s3;
  stanje( int ii, int t1, int t2, int t3 ) { i=ii; s1=t1; s2=t2; s3=t3; }

  friend bool operator < (stanje a, stanje b) {
    if( a.s1 != b.s1 ) return a.s1 < b.s1;
    if( a.s2 != b.s2 ) return a.s2 < b.s2;
    if( a.s3 != b.s3 ) return a.s3 < b.s3;
    return a.i < b.i;
  }
};

int n;
int f[100];
map<stanje, int> memo;
const int inf = 1000000;

int rec( int x, int s1, int s2, int s3 ) {
  if( x == n ) return s1 >? s2 >? s3;

  stanje s(x,s1,s2,s3);
  if( memo.count( s ) ) return memo[s];

  int ret = inf;
  for( int i = 0; i < 6; ++i ) {
    int m = -inf, t1 = s1, t2 = s2, t3 = s3;

    if( b[f[x]][i][0][1] ) m >?= s1-b[f[x]][i][0][0];
    if( b[f[x]][i][1][1] ) m >?= s2-b[f[x]][i][1][0];
    if( b[f[x]][i][2][1] ) m >?= s3-b[f[x]][i][2][0];
    if( b[f[x]][i][0][1] ) t1  =  m+b[f[x]][i][0][1];
    if( b[f[x]][i][1][1] ) t2  =  m+b[f[x]][i][1][1];
    if( b[f[x]][i][2][1] ) t3  =  m+b[f[x]][i][2][1];

    m = t1 <? t2 <? t3;
    ret <?= m + rec( x+1, t1-m, t2-m, t3-m );
  }
  return memo[s] = ret;
}

int main( void ) {
  init();

  cin >> n;
  for( int i = 0; i < n; ++i ) { cin >> f[i]; f[i]--; }

  cout << rec( 0, 0, 0, 0 ) << endl;
  return 0;
}
