
{
Izborne pripreme 2004 - Drugi izborni ispit
Zadatak TETRIS
}

{
   OPIS ALGORITMA: Najprije je potrebno opisati tetris figure i njihove rotacije
   na nacin prihvatljiv racunalu. Buduci da je ogranicenje u zadatku najvise
   100 figura, a visina najvise figure je 4, mozemo zakljuciti da visina stupca
   ne kraju nikad nece biti visa od 400, sto je znatno manje od 1000 sto je ogranicenje
   iz zadatka. Takoder znamo da se figura, dok pada, ne moze micati lijevo-desno
   iz cega slijedi da nam nije bitno ima li praznih mjesta ispod najvise kocke u nekom stupcu.
   Sada mozemo rjesiti zadatak dinamckim programiranjem: neka nam je min(i,s1,s2) minimalna
   visina 3. stupca ako su s1 i s2 visine prvog i drugog stupca, a iskoristili smo prvih i figura.
   Ako pokusamo postaviti i+1. figuru na sve moguce nacine, te znamo min(i,s1,s2) za svaki
   s1 i s2, tada znamo min(i+1,s1,s2) za svaki s1 i s2. Na pocetku znamo min(0,s1,s2), pa iz toga
   mozemo dobiti min(1,s1,s2) i tako dalje do n (broj figura). Nadimo par s1, s2 za koji je
   max3(s1,s2,min(n,s1,s2)) minimalan i imamo rjesenje.

   Vremensko ogranicenje: ako je mv gornja granica rjesenja (400),
   vremenska slozenost je O(mv*mv*n)

   Prostorna slozenost: Primjetimo da nam je za izracunavanje min(i,s1,s2) potreban
   samo min(i-1,s1,s2), znaci da trebamo cuvati samo 1 prethodni red, a ne sve.
   Kada iskoristimo tu cinjenicu dobijemo prostornu slozenost O(mv*mv)
}

const max=410;

    treba:array[0..6,0..5,0..2] of integer=
	 	  (((1,0,0), (0,1,0), (0,0,1), (0,0,0), (0,0,0), (0,0,0)),
                   ((1,1,0), (0,1,1), (1,1,1), (1,1,0), (0,1,1), (1,1,1)),
                   ((1,1,0), (0,1,1), (1,1,1), (1,1,0), (0,1,1), (1,1,1)),
                   ((1,1,1), (1,1,0), (0,1,1), (1,1,1), (1,1,0), (0,1,1)),
                   ((1,1,1), (1,1,0), (0,1,1), (0,0,0), (0,0,0), (0,0,0)),
                   ((1,1,1), (1,1,0), (0,1,1), (0,0,0), (0,0,0), (0,0,0)),
                   ((1,1,0), (0,1,1), (0,0,0), (0,0,0), (0,0,0), (0,0,0)));

    tmin:array[0..6,0..5,0..2] of integer=
		  (((0,0,0), (0,0,0), (0,0,0),(0,0,0), (0,0,0), (0,0,0)),
                   ((0,-2,0), (0,0,-2), (-1,-1,0), (0,0,0), (0,0,0), (0,0,0)),
                   ((-2,0,0), (0,-2,0), (0,0,0), (0,0,0), (0,0,0), (0,-1,-1)),
                   ((0,0,0), (0,-1,0), (0,0,-1), (-1,0,-1), (-1,0,0), (0,-1,0)),
                   ((0,0,-1), (-1,0,0), (0,-1,0), (0,0,0), (0,0,0), (0,0,0)),
                   ((-1,0,0), (0,-1,0), (0,0,-1), (0,0,0), (0,0,0), (0,0,0)),
                   ((0,0,0), (0,0,0), (0,0,0), (0,0,0), (0,0,0), (0,0,0) ));

    tpov:array[0..6,0..5,0..2] of integer=
         	  (((4,0,0), (0,4,0), (0,0,4), (0,0,0), (0,0,0), (0,0,0)),
                   ((3,3,0), (0,3,3), (2,2,2), (1,3,0), (0,1,3), (2,1,1)),
                   ((3,3,0), (0,3,3), (1,1,2), (3,1,0), (0,3,1), (2,2,2)),
                   ((1,2,1), (3,2,0), (0,3,2), (2,2,2), (2,3,0), (0,2,3)),
                   ((1,2,2), (3,2,0), (0,3,2), (0,0,0), (0,0,0), (0,0,0)),
                   ((2,2,1), (2,3,0), (0,2,3), (0,0,0), (0,0,0), (0,0,0)),
                   ((2,2,0), (0,2,2), (0,0,0), (0,0,0), (0,0,0), (0,0,0)));

    koliko:array[0..6] of integer = (3,6,6,6,3,3,2);

var best:array[0..1,0..max,0..max] of integer;
    rez,n,stupac,tmp,i,j,k,l,t:integer;

function max3(t1,t2,t3:longint) :longint;
begin

     if(t1>=t2) and (t1>=t3) then max3:=t1;
     if(t2>=t1) and (t2>=t3) then max3:=t2;
     if(t3>=t2) and (t3>=t1) then max3:=t3;
end;

procedure postavi(tj,rot,t1,t2,koji:longint);
var r1,r2,r3,max:longint;
begin
     max:=0;
     r1:=t1;
     r2:=t2;
     r3:=best[koji xor 1][t1][t2];

     if (treba[tj][rot][0]>0) then
        if(r1+tmin[tj][rot][0]>max) then
           max:=r1+tmin[tj][rot][0];

     if (treba[tj][rot][1]>0) then
        if(r2+tmin[tj][rot][1]>max) then
           max:=r2+tmin[tj][rot][1];

     if (treba[tj][rot][2]>0) then
        if(r3+tmin[tj][rot][2]>max) then
           max:=r3+tmin[tj][rot][2];

     if treba[tj][rot][0]<>0 then
        r1:=max+tpov[tj][rot][0];

     if treba[tj][rot][1]<>0 then
        r2:=max+tpov[tj][rot][1];

     if treba[tj][rot][2]<>0 then
        r3:=max+tpov[tj][rot][2];

     if (best[koji][r1][r2]=-1) or (r3<best[koji][r1][r2]) then
        best[koji][r1][r2]:=r3;


end;

procedure clear(koji:longint);
var i,j:longint;
begin
     for i:=0 to max-1 do
         for j:=0 to max-1 do
             best[koji][i][j]:=-1;
end;

begin

     clear(0);
     clear(1);

     best[0][0][0]:=0;

     readln(n);
     stupac:=0;

     for i:=0 to n-1 do begin
         readln(t);
         t:=t-1;
         for j:=0 to koliko[t]-1 do
             for k:=0 to max-1 do
                 for l:=0 to max-1 do
                     if best[stupac][k][l]<>-1 then postavi(t,j,k,l,stupac xor 1);

         clear(stupac);
         stupac:=stupac xor 1;
     end;

     rez:=max;
     for i:=0 to max-1 do
         for j:=0 to max-1 do
             if best[stupac][i][j]<>-1 then begin
                tmp:=max3(i,j,best[stupac][i][j]);
                if(tmp<rez) then rez:=tmp;
             end;

     writeln(rez);
end.
