
/*
  Izborne pripreme 2006 - Prvi izborni ispit
  Zadatak KARLA

  Neka je stanje zadano uredjenom petorkom (red, stupac, mostova, suma, otkud).

  red, stupac - polje na kojem se nalazimo
  mostova - koliko smo mostova dosad izgradili
  suma - koliko smo suma dosad spalili
  otkud - iz kojeg smjera smo dosli na trenutno polje

  Pretrazujemo po stanjima pocevsi iz gornjeg desnog kuta s 0 izgradjenih mostova
  i 0 spaljenih suma, pritom imajuci na umu:

  * Ako stanemo na polje na kojem se nalazi suma, a prije nismo bili u sumi
    moramo je spaliti.
  * Ako stanemo na polje na kojem se nalazi voda, moramo pocet graditi most i
    nastaviti se micati u istom smjeru sve dok se nalazimo na vodi.
  * Broj izgradjenih mostova i spaljenih suma ne smije preci zadano ogranicenje.

  Radi rekonstrukcije rjesenja potrebno je za svako stanje pamtiti prethodno
  stanje.
*/

#include <cstdio>
#include <cstring>
#include <queue>

using namespace std;

struct state {
   short r, c, x, y, d;
   state() {}
   state( int R, int C, int X, int Y, int D ) { r=R; c=C; x=X; y=Y; d=D; }

   int & dist();
   state & how();
};
int   dd[50][50][11][11][4]; int & state::dist() { return dd[r][c][x][y][d]; }
state hh[50][50][11][11][4]; state & state::how() { return hh[r][c][x][y][d]; }

int N, M;
int X, Y;
char a[50][50+1];

const int dr[4] = { -1, 0, 1, 0 };
const int dc[4] = { 0, 1, 0, -1 };

void update( queue<state> &Q, state &B, state &A, int val ) {
   if( B.dist() <= val ) return;
   B.dist() = val;
   B.how() = A;
   Q.push( B );
}

void spali( int r, int c ) {
   if( r < 0 || r >= N || c < 0 || c >= M ) return;
   if( a[r][c] != 's' ) return;
   a[r][c] = '.';
   for( int d = 0; d < 4; ++d )
      spali( r+dr[d], c+dc[d] );
}

void reconstruct( state &A ) {
   if( A.r == 0 && A.c == 0 ) return;

   if( a[A.r][A.c] == '-' || a[A.r][A.c] == '|' ) a[A.r][A.c] = '+';
   if( a[A.r][A.c] == 'v' ) {
      if( A.d == 0 || A.d == 2 ) a[A.r][A.c] = '|';
      if( A.d == 1 || A.d == 3 ) a[A.r][A.c] = '-';
   }
   if( a[A.r][A.c] == 's' ) spali( A.r, A.c );

   reconstruct( A.how() );
}

int main( void ) {
   scanf( "%d%d", &N, &M );
   scanf( "%d%d", &X, &Y );

   for( int i = 0; i < N; ++i ) scanf( "%s\n", a[i] );

   memset( dd, 0x3F, sizeof dd );

   queue<state> Q;
   state A( 0, 0, 0, 0, 0 );
   for( update( Q, A, A, 0 ); !Q.empty(); Q.pop() ) {
      A = Q.front();
      if( A.r == N-1 && A.c == M-1 ) break;

      for( int d = 0; d < 4; ++d ) {
         state B( A.r+dr[d], A.c+dc[d], A.x, A.y, d );

         if( B.r < 0 || B.r >= N ) continue;
         if( B.c < 0 || B.c >= M ) continue;

         if( a[B.r][B.c] == '#' ) continue;

         if( a[A.r][A.c] == 'v' && A.d != B.d ) continue;

         if( a[B.r][B.c] == 'v' && a[A.r][A.c] != 'v' ) B.x++;
         if( a[B.r][B.c] == 's' && a[A.r][A.c] != 's' ) B.y++;

         if( B.x > X ) continue;
         if( B.y > Y ) continue;

         update( Q, B, A, A.dist()+1 );
      }
   }

   reconstruct( A );
   for( int i = 0; i < N; ++i )
      printf( "%s\n", a[i] );

   return 0;
}
