
/*
  Izborne pripreme 2006 - Prvi izborni ispit
  Zadatak SEVERINA

  Zadatak je rjesavamo koristeci metodu dinamickog programiranja. Neka je
  vrijednost funkcije F(x) broj nacina na koji se prvih x znakova pjesme moze
  rastaviti na dane rijeci.

  Da bi mogli izracunati vrijednost funkcije F(x) dovoljno je odrediti
  vrijednosti funkcije F(y) za svaki y < x i to cinimo pomocu donjeg algoritma:

  F(x) = 0
  Za svaku rijec A
    Ako prvih x znakova teksta zavrsava s rijeci A
      F(x) = F(x) + F(x - duljina(A))

  Slozenost takvog algoritma za izracunavanje F(x) za svaki x je
  O(duljina_teksta * broj_rijeci * maksimalna_duljina_rijeci).

  Umjesto da za svaku rijec provjeravamo zavrsava li prvih x znakova teksta tom
  rijeci, mozemo za svaki zavrsetak prvih x znakova teksta provjeriti postoji li
  ta rijec medju danim rijecima.

  Ako sve rijeci prethodno ubacimo u strukturu zvanu 'suffix trie', tada mozemo
  dodavajuci slovo po slovo u svakom trenutku znati postoji li neka rijec ili ne.

  Na taj nacin eliminiramo broj_rijeci iz algoritma, pa je slozenost takvog
  algoritma O(duljina_teksta * maksimalna_duljina_rijeci).

  Donja implementacija rjesava problem naopacke, pa koristi prefix, a ne suffix
  trie.
*/

#include <cstdio>
#include <cstring>

using namespace std;

#define SLOVA 26
#define NIZ 300000
#define RIJECI 4000
#define LEN 100
#define MOD 1337377

char niz[NIZ+1];
int dp[NIZ+1];

struct node {
   char flag;
   int p[SLOVA];
   void clear() { memset( p, -1, sizeof p ); flag = 0; }
};
node dict[RIJECI*LEN];
int new_node() {
   static int mem_ptr = 0;
   dict[mem_ptr].clear();
   return mem_ptr++;
}

int main( void ) {
   int n, m;
   gets( niz );
   m = strlen( niz );
   scanf( "%d", &n );

   int root = new_node();
   for( int i = 0; i < n; ++i ) {
      static char buff[LEN+1];
      scanf( "%s", buff );

      int t = root;
      for( char *c = buff; *c; ++c ) {
         if( dict[t].p[*c-'a'] == -1 ) dict[t].p[*c-'a'] = new_node();
         t = dict[t].p[*c-'a'];
      }
      dict[t].flag = 1;
   }

   dp[m] = 1;

   for( int i = m-1; i >= 0; --i ) {
      int t = root;
      for( int j = i; j < m; ++j ) {
         t = dict[t].p[niz[j]-'a'];
         if( t == -1 ) break;

         if( dict[t].flag ) dp[i] = ( dp[i] + dp[j+1] ) % MOD;
      }
      dp[i] %= MOD;
   }

   printf( "%d\n", dp[0] );

   return 0;
}
