
/*
  Izborne pripreme 2006 - Drugi izborni ispit
  Zadatak FORMULE

  Promotrimo prvo jednostavniju varijantu zadatka sa samo jednom varijablom
  (npr varijablom 0).

  Moguca su tri slucaja:

  1) Varijabla se ne pojavljuje u formulama ili iz formula proizlazi 0 = 0
  2) Iz formula proizlazi 0 je temeljna formula
  3) Iz formula proizlazi 0 je funkcija, a nije temeljna formula

  Rjesenje za prvi slucaj je trivijalno, npr. 0 = a.

  Rjesenje za drugi slucaj je naravno 0 = temeljna formula, pa se zadatak svodi
  na jednostavnu manipulaciju stringovima.

  Treci slucaj je specifican zbog toga sto nema rjesenja.
  Promotrimo sljedeci primjer:
  0
  F(0,a)
  Iz unosa proizlazi da je 0 = F(0,a), ukoliko to uvrstimo dobivamo:
  F(0,a)
  F(F(0,a),a)

  Ocito je da ovaj postupak mozemo ponavljati beskonacno puta, pa slucaj nema
  rjesenja. Buduci da tekst zadatka garantira da ce rjesenje postojati treci
  slucaj mozemo zanemariti.

  Vratimo se sad na originalni zadatak sa dvije varijable. Za rjesenje zadatka
  dovoljno je naci bilo koju jednakost varijabla=formula i jednostavno je
  uvrstiti u pocetne formule.

  Buduci da rjesenje mora postojati, formula na desnoj strani jednakosti nece
  sadrzavati varijablu s lijeve strane jednakosti, pa se zamjenom varijable s
  tom formulom varijabla gubi i ostaje nam problem s jednom varijablom koji
  smo vec gore rijesili.
*/

#include <algorithm>
#include <iostream>
#include <map>
#include <string>
#include <vector>

using namespace std;

typedef pair<string,string> par;

int a, b;
string prvi;
string drugi;

map<char, string> ret;

void replace( string &s, par p ) {
   for( int f; (f = s.find( p.first )) != string::npos; ) {
      s.erase( f, 1 );
      s.insert( f, p.second );
   }
}

void zamijeni( par p ) {
   ret[p.first[0]] = p.second;
   replace( prvi, p );
   replace( drugi, p );
   replace( ret['0'], p );
   replace( ret['1'], p );
}

par parse( int e1, int e2 ) {
   par ret;
   if( !e1 && !e2 ) return ret;

   char A = '#', B = '#';
   if( e1 ) ret.first += A = prvi[a++];
   if( e2 ) ret.second += B = drugi[b++];

   if( !isupper(A) ) e1 = 0;
   if( !isupper(B) ) e2 = 0;

   {
      if( e1 ) { ++a; ret.first  += "("; }
      if( e2 ) { ++b; ret.second += "("; }

      par tmp1 = parse( e1, e2 );
      ret.first  += tmp1.first;
      ret.second += tmp1.second;

      if( e1 ) { ++a; ret.first  += ","; }
      if( e2 ) { ++b; ret.second += ","; }

      par tmp2 = parse( e1, e2 );
      ret.first  += tmp2.first;
      ret.second += tmp2.second;

      if( e1 ) { ++a; ret.first  += ")"; }
      if( e2 ) { ++b; ret.second += ")"; }
   }

   if( isdigit(A) && e2 ) throw par( string(1,A), ret.second );
   if( isdigit(B) && e1 ) throw par( string(1,B), ret.first );

   return ret;
}

int main( void ) {
   cin >> prvi >> drugi;

   try { a = b = 0; parse( 1, 1 ); } catch( par p ) { zamijeni( p ); }
   try { a = b = 0; parse( 1, 1 ); } catch( par p ) { zamijeni( p ); }

   if( ret['0'] == "" ) zamijeni( par( "0", "x" ) );
   if( ret['1'] == "" ) zamijeni( par( "1", "x" ) );

   if( prvi != drugi ) {
      cout << "NEMOGUCE" << endl;
   } else {
      cout << "0=" << ret['0'] << endl;
      cout << "1=" << ret['1'] << endl;
   }

   return 0;
}
