
{
  Izborne pripreme 2006 - Drugi izborni ispit
  Zadatak FORMULE

  Promotrimo prvo jednostavniju varijantu zadatka sa samo jednom varijablom
  (npr varijablom 0).

  Moguca su tri slucaja:

  1) Varijabla se ne pojavljuje u formulama ili iz formula proizlazi 0 = 0
  2) Iz formula proizlazi 0 je temeljna formula
  3) Iz formula proizlazi 0 je funkcija, a nije temeljna formula

  Rjesenje za prvi slucaj je trivijalno, npr. 0 = a.

  Rjesenje za drugi slucaj je naravno 0 = temeljna formula, pa se zadatak svodi
  na jednostavnu manipulaciju stringovima.

  Treci slucaj je specifican zbog toga sto nema rjesenja.
  Promotrimo sljedeci primjer:
  0
  F(0,a)
  Iz unosa proizlazi da je 0 = F(0,a), ukoliko to uvrstimo dobivamo:
  F(0,a)
  F(F(0,a),a)

  Ocito je da ovaj postupak mozemo ponavljati beskonacno puta, pa slucaj nema
  rjesenja. Buduci da tekst zadatka garantira da ce rjesenje postojati treci
  slucaj mozemo zanemariti.

  Vratimo se sad na originalni zadatak sa dvije varijable. Za rjesenje zadatka
  dovoljno je naci bilo koju jednakost varijabla=formula i jednostavno je
  uvrstiti u pocetne formule.

  Buduci da rjesenje mora postojati, formula na desnoj strani jednakosti nece
  sadrzavati varijablu s lijeve strane jednakosti, pa se zamjenom varijable s
  tom formulom varijabla gubi i ostaje nam problem s jednom varijablom koji
  smo vec gore rijesili.
}

program formule;

procedure razdvoji( a : AnsiString; var x, y : AnsiString );
var
   c, i : integer;
begin
   c := 0;
   for i := 1 to length( a ) do begin
      if a[i] = '(' then c := c + 1
      else if a[i] = ')' then c := c - 1
      else if (c = 1) and (a[i] = ',') then begin
         x := copy( a, 3, i-3 );
         y := copy( a, i+1, length(a)-i-1 );
      end;
   end;
end;

function zamijeni( x0, x1, a : AnsiString ) : AnsiString;
var
   i : integer;
   s : AnsiString;
begin
   s := '';
   for i := 1 to length( a ) do begin
      if a[i] = '0' then s := s + x0
      else if a[i] ='1' then s := s + x1
      else s := s + a[i];
   end;
   zamijeni := s;
end;

function isupper( c : char ) : boolean;
begin
   if (ord(c) >= 65) and (ord(c) <= 90) then
      isupper := true
   else
      isupper := false;
end;

function isalpha( c : char ) : boolean;
begin
   if (ord(c) >= 65) and (ord(c) <= 90) then
      isalpha := true
   else if (ord(c) >= 97) and (ord(c) <= 122) then
      isalpha := true
   else
      isalpha := false;
end;

function nadji( a, b : AnsiString; var x, y : AnsiString ) : integer;
var
   a1, a2 : AnsiString;
   b1, b2 : AnsiString;
   t : AnsiString;

begin
   if a = b then begin
      nadji := 1;
      exit;
   end;

   if isupper(a[1]) and (a[1]=b[1]) then begin

      razdvoji(a, a1, a2);
      razdvoji(b, b1, b2);

      if nadji(a1, b1, x, y) = 0 then begin
         nadji := 0;
         exit;
      end;
      if nadji(zamijeni(x, y, a2), zamijeni(x, y, b2), x, y) = 0 then
         nadji := 0
      else
         nadji := 1;

      exit;
   end;

   if isalpha(a[1]) and isalpha(b[1]) then begin
      nadji := 0;
      exit;
   end;

   if (a <> '0') and (a <> '1') then begin
      t := a;
      a := b;
      b := t;
   end;

   if Pos( a[1], b ) > 0 then begin
      nadji := 0;
      exit;
   end;

   if a = '0' then x := b;
   if a = '1' then y := b;

   nadji := 1;
end;

var
   a, b, c, d : AnsiString;

begin
   readln( a );
   readln( b );
   c := '0';
   d := '1';
   if nadji(a, b, c, d) = 1 then begin
      if Pos( '1', c ) > 0 then c := zamijeni('0', d, c);
      if Pos( '0', d ) > 0 then d := zamijeni(c, '1', d);
      c := zamijeni('x', 'y', c);
      d := zamijeni('x', 'y', d);
      writeln( '0=', c );
      writeln( '1=', d );
   end else
      writeln( 'Nemoguce' );
end.
