
/*
  Izborne pripreme 2006 - Drugi izborni ispit
  Zadatak LUBENICA

  Prometnu mrezu gradova mozemo predstaviti stablom. Gradovi su cvorovi u
  stablu, a bridovi su ceste medju njima. Kazemo da je cvor A potomak od B, ako
  se A nalazi u potstablu s korijenom u cvoru B. Ako je A potomak od B, tada je
  B predak od A.

  Put izmedju bilo koja dva cvora A i B spada u jedan od tri slucaja:

  1) A je potomak od B
  2) B je potomak od A
  3) Postoji cvor C koji je predak od A i B.

  U slucajevima 1) i 2) put ide direktno iz A u B, a u slucaju C, put ide iz
  cvora A gore prema cvoru C, pa iz cvora C dolje prema cvoru B.

  Neka svaki cvor u stablu pamti tko mu je 2^i-ti predak za svaki i od 0 do 16.
  Oznacimo to sa p[A][i]. Osim sto pamtimo tko je taj predak, pamtimo i najmanju
  i najvecu cestu na putu do njega.

  Opcenito vrijedi:
     p[A][i+1] = p[ p[A][i] ][i]

  Drugim rijecima, ako je cvor Y 2^i-ti predak od X, a cvor Z 2^i-ti predak od Y,
  tada je Z 2^(i+1)-ti predak od X.

  Sada mozemo odrediti duljinu najdulje i najkrace ceste izmedju nekog para
  gradova u sluzenosti O(log N) ovako:

  Prvo cvor koji je na vecoj dubini dizemo po stablu, tako da cvorovi budu na
  istoj razini. U svakom trenutku cvor dizemo za najvecu potenciju broja 2 takvu
  da ne dodjemo iznad drugog cvora.

  Ako se radi o slucaju 1) ili 2), tada smo nasli cijeli put i gotovi smo. Inace,
  trazimo najnizi cvor C koji je predak od oba cvora.

  To radimo tako da dizemo oba cvora zajedno za najvecu potenciju broja 2 takvu
  da ne dodjemo u isti cvor iz oba cvora. Nakon tog procesa, prvi predak od oba
  cvora biti ce trazeni cvor C.

  Naravno, prilikom svakog dizanja bilo kojeg cvora, provjeravamo je li najveca
  i najmanja cesta na toj dionici puta najmanja ili najveca od svih dosada.
*/

#include <algorithm>
#include <cstdio>
#include <cstring>
#include <queue>
#include <vector>

using namespace std;

#define MAX 100000

typedef pair<int,int> par;

inline void operator <?= ( par &A, const par &B ) {
   A.first <?= B.first;
   A.second >?= B.second;
}

vector<par> adj[MAX];
int hibit[2*MAX];
int dubina[MAX];
int p[MAX][17];
par a[MAX][17];

struct state {
   int x, depth;
   par edge;
   state( int X, int D, const par &E ) { x=X; depth=D; edge=E; }
};

void bfs() {
   queue<state> Q;

   for( Q.push( state(0,0,par(-1,0)) ); !Q.empty(); Q.pop() ) {
      int x = Q.front().x;
      int depth = Q.front().depth;
      par edge = Q.front().edge;

      dubina[x] = depth;
      p[x][0] = edge.first;
      a[x][0] = par( edge.second, edge.second );
      for( int i = 1; i <= hibit[depth]; ++i ) {
         p[x][i] = p[ p[x][i-1] ][i-1];
         a[x][i] = a[x][i-1];
         a[x][i] <?= a[ p[x][i-1] ][i-1];
      }

      for( vector<par>::iterator it = adj[x].begin(); it != adj[x].end(); ++it ) {
         if( it->first == edge.first ) continue;
         Q.push( state( it->first, depth+1, par(x,it->second) ) );
      }
   }
}

int main( void ) {
   for( int i = 0; i < 17; ++i )
      for( int j = 0; j < (1<<i); ++j )
         hibit[(1<<i)+j] = i;

   int n;
   scanf( "%d", &n );
   for( int i = 1; i < n; ++i ) {
      int A, B, C;
      scanf( "%d%d%d", &A, &B, &C ); --A; --B;

      adj[A].push_back( par(B,C) );
      adj[B].push_back( par(A,C) );
   }

   memset( p, -1, sizeof p );
   bfs();

   int k;
   scanf( "%d", &k );
   for( int i = 0; i < k; ++i ) {
      int A, B;
      scanf( "%d%d", &A, &B ); --A; --B;
      if( dubina[A] > dubina[B] ) swap( A, B );

      par ret( 1000000, 0 );

      while( dubina[A] != dubina[B] ) {
         int delta = dubina[B] - dubina[A];
         ret <?= a[B][ hibit[delta] ];
         B = p[B][ hibit[delta] ];
      }

      if( A != B ) {
         for( int i = hibit[dubina[A]]; i >= 0; --i ) {
            if( p[A][i] == p[B][i] ) continue;
            ret <?= a[A][i]; A = p[A][i];
            ret <?= a[B][i]; B = p[B][i];
         }
         ret <?= a[A][0];
         ret <?= a[B][0];
      }

      printf( "%d %d\n", ret.first, ret.second );
   }

   return 0;
}
