
{
  Izborne pripreme 2006 - Drugi izborni ispit
  Zadatak LUBENICA

  Prometnu mrezu gradova mozemo predstaviti stablom. Gradovi su cvorovi u
  stablu, a bridovi su ceste medju njima. Kazemo da je cvor A potomak od B, ako
  se A nalazi u potstablu s korijenom u cvoru B. Ako je A potomak od B, tada je
  B predak od A.

  Put izmedju bilo koja dva cvora A i B spada u jedan od tri slucaja:

  1) A je potomak od B
  2) B je potomak od A
  3) Postoji cvor C koji je predak od A i B.

  U slucajevima 1) i 2) put ide direktno iz A u B, a u slucaju C, put ide iz
  cvora A gore prema cvoru C, pa iz cvora C dolje prema cvoru B.

  Neka svaki cvor u stablu pamti tko mu je 2^i-ti predak za svaki i od 0 do 16.
  Oznacimo to sa p[A][i]. Osim sto pamtimo tko je taj predak, pamtimo i najmanju
  i najvecu cestu na putu do njega.

  Opcenito vrijedi:
     p[A][i+1] = p[ p[A][i] ][i]

  Drugim rijecima, ako je cvor Y 2^i-ti predak od X, a cvor Z 2^i-ti predak od Y,
  tada je Z 2^(i+1)-ti predak od X.

  Sada mozemo odrediti duljinu najdulje i najkrace ceste izmedju nekog para
  gradova u sluzenosti O(log N) ovako:

  Prvo cvor koji je na vecoj dubini dizemo po stablu, tako da cvorovi budu na
  istoj razini. U svakom trenutku cvor dizemo za najvecu potenciju broja 2 takvu
  da ne dodjemo iznad drugog cvora.

  Ako se radi o slucaju 1) ili 2), tada smo nasli cijeli put i gotovi smo. Inace,
  trazimo najnizi cvor C koji je predak od oba cvora.

  To radimo tako da dizemo oba cvora zajedno za najvecu potenciju broja 2 takvu
  da ne dodjemo u isti cvor iz oba cvora. Nakon tog procesa, prvi predak od oba
  cvora biti ce trazeni cvor C.

  Naravno, prilikom svakog dizanja bilo kojeg cvora, provjeravamo je li najveca
  i najmanja cesta na toj dionici puta najmanja ili najveca od svih dosada.
}

program lubenica;

const MAX = 100000;

type
   par = record
      first, second : longint;
   end;
   brid = record
      u, v, d : longint;
   end;
   state = record
      x, depth : longint;
      edge : par;
   end;

procedure popravi( var A, B : par );
begin
   if B.first < A.first then A.first := B.first;
   if B.second > A.second then A.second := B.second;
end;

var
   lista : array[1..MAX] of longint;
   bridovi : array[1..2*MAX] of brid;
   next : array[1..2*MAX] of longint;
   hibit : array[1..2*MAX] of longint;
   dubina : array[1..MAX] of longint;
   p : array[1..MAX, 0..16] of longint;
   m : array[1..MAX, 0..16] of par;
   n, i, j, k, t : longint;
   A, B, C : longint;
   ret : par;
   delta : longint;

   queue : array[1..MAX] of state;
   qhead, qtail : longint;

procedure bfs;
var
   S, T : state;
   i : longint;
begin
   S.x := 1; S.depth := 0;
   S.edge.first := 0; S.edge.second := 0;

   queue[qtail] := S;
   qtail := qtail + 1;
   while qhead < qtail do begin
      S := queue[qhead];
      qhead := qhead + 1;

      dubina[S.x] := S.depth;
      p[S.x][0] := S.edge.first;
      m[S.x, 0].first := S.edge.second;
      m[S.x, 0].second := S.edge.second;
      for i := 1 to hibit[ S.depth ] do begin
         p[S.x, i] := p[ p[S.x, i-1], i-1];
         m[S.x, i] := m[S.x, i-1];
         popravi( m[S.x, i], m[ p[S.x, i-1], i-1] );
      end;

      i := lista[S.x];
      while i <> 0 do begin
         if bridovi[i].v <>S.edge.first then begin;

            T.x := bridovi[i].v; T.depth := S.depth + 1;
            T.edge.first := S.x; T.edge.second := bridovi[i].d;

            queue[qtail] := T;
            qtail := qtail + 1;
         end;

         i := next[i];
      end;
   end;
end;

begin
   for i := 0 to 16 do
      for j := 0 to (1 shl i)-1 do
         hibit[(1 shl i)+j] := i;

   readln( n );

   for i := 1 to n do lista[i] := 0;

   for i := 1 to n-1 do begin
      readln( A, B, C );
      bridovi[2*i-1].u := A; bridovi[2*i-1].v := B; bridovi[2*i-1].d := C;
      bridovi[2*i  ].u := B; bridovi[2*i  ].v := A; bridovi[2*i  ].d := C;

      next[2*i-1] := lista[A]; lista[A] := 2*i-1;
      next[2*i  ] := lista[B]; lista[B] := 2*i;
   end;

   for i := 1 to n do
      for j := 0 to 16 do
         p[i, j] := 0;
   bfs;
   readln( k );
   for i := 1 to k do begin
      readln( A, B );
      if dubina[A] > dubina[B] then begin
         t := A; A := B; B := t;
      end;

      ret.first := 1000000; ret.second := 0;

      while dubina[A] <> dubina[B] do begin
         delta := dubina[B] - dubina[A];
         popravi( ret, m[B, hibit[delta] ] );
         B := p[B, hibit[delta] ];
      end;

      if A <> B then begin
         for j := hibit[ dubina[A] ] downto 0 do begin

            if p[A, j] = p[B, j] then continue;

            popravi( ret, m[A, j] ); A := p[A, j];
            popravi( ret, m[B, j] ); B := p[B, j];
         end;
         popravi( ret, m[A, 0] );
         popravi( ret, m[B, 0] );
      end;

      writeln( ret.first, ' ', ret.second );
   end;
end.
