
{
  Izborne pripreme 2006 - Prvi izborni ispit
  Zadatak KARLA

  Neka je stanje zadano uredjenom petorkom (red, stupac, mostova, suma, otkud).

  red, stupac - polje na kojem se nalazimo
  mostova - koliko smo mostova dosad izgradili
  suma - koliko smo suma dosad spalili
  otkud - iz kojeg smjera smo dosli na trenutno polje

  Pretrazujemo po stanjima pocevsi iz gornjeg desnog kuta s 0 izgradjenih mostova
  i 0 spaljenih suma, pritom imajuci na umu:

  * Ako stanemo na polje na kojem se nalazi suma, a prije nismo bili u sumi
    moramo je spaliti.
  * Ako stanemo na polje na kojem se nalazi voda, moramo pocet graditi most i
    nastaviti se micati u istom smjeru sve dok se nalazimo na vodi.
  * Broj izgradjenih mostova i spaljenih suma ne smije preci zadano ogranicenje.

  Radi rekonstrukcije rjesenja potrebno je za svako stanje pamtiti prethodno
  stanje.
}

program karla;

type
   state = record
      r, c, x, y, d : integer;
   end;

var
   dist : array[1..50, 1..50, 0..10, 0..10, 1..4] of longint;
   how : array[1..50, 1..50, 0..10, 0..10, 1..4] of state;
   N, M : integer;
   K, L : integer;
   mapa : array[1..50, 1..50] of char;
   i, r, c, x, y, d : integer;
   A, B : state;

   dr : array[1..4] of integer;
   dc : array[1..4] of integer;

   queue : array[1..50*50*11*11*4] of state;
   qhead, qtail : longint;

procedure update( B, A : state; val : longint );
begin
   if dist[B.r, B.c, B.x, B.y, B.d] <= val then exit;

   dist[B.r, B.c, B.x, B.y, B.d] := val;
   how[B.r, B.c, B.x, B.y, B.d] := A;

   queue[qtail] := B;
   qtail := qtail + 1;
end;

procedure spali( r, c : integer );
var
   d : integer;
begin
   if (r < 1) or (r > N) or (c < 1) or (c > M) then exit;
   if mapa[r][c] <> 's' then exit;

   mapa[r][c] := '.';
   for d := 1 to 4 do
      spali( r+dr[d], c+dc[d] );
end;

procedure reconstruct( A : state );
begin
   if (A.r = 1) and (A.c = 1) then exit;

   if (mapa[A.r][A.c] = '-') or (mapa[A.r][A.c] = '|') then mapa[A.r][A.c] := '+';

   if mapa[A.r][A.c] = 'v' then begin
      if (A.d = 1) or (A.d = 3) then mapa[A.r][A.c] := '|';
      if (A.d = 2) or (A.d = 4) then mapa[A.r][A.c] := '-';
   end;

   if mapa[A.r][A.c] = 's' then spali( A.r, A.c );

   reconstruct( how[A.r, A.c, A.x, A.y, A.d] );
end;

begin
   dr[1] := -1; dr[2] := 0; dr[3] := 1; dr[4] :=  0;
   dc[1] :=  0; dc[2] := 1; dc[3] := 0; dc[4] := -1;

   readln( N, M );
   readln( K, L );

   for i := 1 to N do readln( mapa[i] );

   for r := 1 to N do
      for c := 1 to M do
         for x := 0 to 10 do
            for y := 0 to 10 do
               for d := 1 to 4 do
                  dist[r, c, x, y, d] := 1000000000;

   qhead := 1; qtail := 1;
   A.r := 1; A.c := 1; A.x := 0; A.y := 0; A.d := 1;
   update( A, A, 0 );

   while qhead < qtail do begin
      A := queue[qhead];
      qhead := qhead + 1;

      if (A.r = N) and (A.c = M) then break;

      for d := 1 to 4 do begin
         B.r := A.r+dr[d]; B.c := A.c+dc[d]; B.x := A.x; B.y := A.y; B.d := d;

         if (B.r < 1) or (B.r > N) then continue;
         if (B.c < 1) or (B.c > M) then continue;

         if mapa[B.r][B.c] = '#' then continue;

         if (mapa[A.r][A.c] = 'v') and (A.d <> B.d) then continue;

         if (mapa[B.r][B.c] = 'v') and (mapa[A.r][A.c] <> 'v') then B.x := B.x + 1;
         if (mapa[B.r][B.c] = 's') and (mapa[A.r][A.c] <> 's') then B.y := B.y + 1;

         if (B.x > K) then continue;
         if (B.y > L) then continue;

         update( B, A, dist[A.r, A.c, A.x, A.y, A.d] + 1 );
      end;
   end;

   reconstruct( A );
   for i := 1 to N do writeln( mapa[i] );

end.
