
{
  Izborne pripreme 2006 - Prvi izborni ispit
  Zadatak SEVERINA

  Zadatak je rjesavamo koristeci metodu dinamickog programiranja. Neka je
  vrijednost funkcije F(x) broj nacina na koji se prvih x znakova pjesme moze
  rastaviti na dane rijeci.

  Da bi mogli izracunati vrijednost funkcije F(x) dovoljno je odrediti
  vrijednosti funkcije F(y) za svaki y < x i to cinimo pomocu donjeg algoritma:

  F(x) = 0
  Za svaku rijec A
    Ako prvih x znakova teksta zavrsava s rijeci A
      F(x) = F(x) + F(x - duljina(A))

  Slozenost takvog algoritma za izracunavanje F(x) za svaki x je
  O(duljina_teksta * broj_rijeci * maksimalna_duljina_rijeci).

  Umjesto da za svaku rijec provjeravamo zavrsava li prvih x znakova teksta tom
  rijeci, mozemo za svaki zavrsetak prvih x znakova teksta provjeriti postoji li
  ta rijec medju danim rijecima.

  Ako sve rijeci prethodno ubacimo u strukturu zvanu 'suffix trie', tada mozemo
  dodavajuci slovo po slovo u svakom trenutku znati postoji li neka rijec ili ne.

  Na taj nacin eliminiramo broj_rijeci iz algoritma, pa je slozenost takvog
  algoritma O(duljina_teksta * maksimalna_duljina_rijeci).

  Donja implementacija rjesava problem naopacke, pa koristi prefix, a ne suffix
  trie.
}

program severina;

const SLOVA = 26;
const MAXNIZ = 300000;
const RIJECI = 4000;
const LEN = 100;
const MODULO = 1337377;

var
   niz : AnsiString;
   dp : array[1..MAXNIZ+1] of longint;
   buff : string;
   n, m : longint;
   root : longint;
   i, j, k, t : longint;

type
   node = record
      flag : boolean;
      p : array[1..SLOVA] of longint;
   end;

procedure clear( var A : node );
var
   i : longint;
begin
   for i := 1 to SLOVA do A.p[i] := -1;
   A.flag := false;
end;

var
   n_dict : longint;
   dict : array[1..RIJECI*LEN] of node;

function new_node() : longint;
begin
   n_dict := n_dict + 1;
   clear( dict[n_dict] );
   new_node := n_dict;
end;

begin
   n_dict := 0;
   readln( niz );
   m := length( niz );

   readln( n );
   root := new_node();
   for i := 1 to n do begin
      readln( buff );
      k := length( buff );

      t := root;
      for j := 1 to k do begin
         if dict[t].p[ord(buff[j])-96] = -1 then
            dict[t].p[ord(buff[j])-96] := new_node();
         t := dict[t].p[ord(buff[j])-96];
      end;
      dict[t].flag := true;
   end;

   dp[m+1] := 1;

   for i := m downto 1 do begin
      t := root;
      for j := i to m do begin
         t := dict[t].p[ord(niz[j])-96];
         if t = -1 then break;

         if dict[t].flag then
            dp[i] := (dp[i] + dp[j+1]) mod MODULO;
      end;
      dp[i] := dp[i] mod MODULO;
   end;

   writeln( dp[1] );
end.
