
(*
  Izborne pripreme 2007
  Zadatak NOGA
*)

program noga;

const 
   BLOCKS = 100;
   BLOCK_SIZE = 1000;
   MODULO = 1023;
   inf = 1000000000;

type
   skakavac = record 
      visina : longint;
      gdje : longint;
   end;
var
   a : array[0..BLOCKS*BLOCK_SIZE] of skakavac;

type
   blok = record 
      size, pocetak, kraj : longint;
      heap : array[1..MODULO] of longint;
      lista : array[0..MODULO] of longint;
   end;
var
   b : array[0..BLOCKS] of blok;


procedure init( var B : blok );
begin
   B.size := 0;
   B.pocetak := 0;
   B.kraj := MODULO;
end;

procedure up_heap( var B : blok; i : longint );
var
   t, j : longint;
begin 
   t := B.heap[i];
   while i > 1 do begin
      j := i div 2;
      if a[B.heap[j]].visina >= a[t].visina then break;

      B.heap[i] := B.heap[j]; a[B.heap[i]].gdje := i;
      i := j;
   end;
   B.heap[i] := t; a[B.heap[i]].gdje := i;
end;

procedure down_heap( var B : blok; i : longint );
var
   t, j : longint;
begin
   t := B.heap[i];
   while i*2 <= B.size do begin
      j := i*2;
      if (j+1 <= B.size) and (a[B.heap[j+1]].visina > a[B.heap[j]].visina) then j := j + 1;
      if a[t].visina >= a[B.heap[j]].visina then break;

      B.heap[i] := B.heap[j]; a[B.heap[i]].gdje := i;
      i := j;         
   end;
   B.heap[i] := t; a[B.heap[i]].gdje := i;
end;

procedure heap_insert( var B : blok; x : longint );
begin;
   B.size := B.size + 1;
   B.heap[B.size] := x; a[B.heap[B.size]].gdje := B.size;
   up_heap( B, B.size );
end;

procedure heap_erase( var B : blok; x : longint );
begin
   B.heap[a[x].gdje] := B.heap[B.size];
   B.size := B.size - 1;
   if B.size > 0 then begin
      up_heap( B, a[x].gdje );
      down_heap( B, a[x].gdje );
   end;
end;

function pop_front( var B : blok ) : longint;
var
   ret : longint;
begin
   ret := B.lista[B.pocetak];
   B.pocetak := (B.pocetak+1) and MODULO;
   heap_erase( B, ret );
   pop_front := ret;
end;

function pop_back( var B : blok ) : longint;
var
   ret : longint;
begin;
   ret := B.lista[B.kraj];
   B.kraj := (B.kraj-1) and MODULO;
   heap_erase( B, ret );
   pop_back := ret;
end;

procedure push_front( var B : blok; x : longint );
begin
   heap_insert( B, x );
   B.pocetak := (B.pocetak-1) and MODULO;
   B.lista[B.pocetak] := x;
end;

procedure push_back( var B : blok; x : longint );
begin
   heap_insert( B, x );
   B.kraj := (B.kraj+1) and MODULO;
   B.lista[B.kraj] := x;
end;

function max( var B : blok ) : longint;
begin
   if B.size = 0 then max := -inf else max := a[B.heap[1]].visina;
end;

function front( var B : blok ) : longint;
begin
   front := B.lista[B.pocetak];
end;

function back( var B : blok ) : longint;
begin
   back := B.lista[B.kraj];
end;

procedure swap( var x, y : longint );
var
   t : longint;
begin
   t := x; x := y; y := t;
end;

procedure maxi( var x : longint; y : longint );
begin
   if y > x then x := y;
end;

var
   n, s : longint;
   m, q, i, j, jj, x : longint;
   start, k : longint;
   c : char;
   ret : longint;
begin
   readln( n, s );
   
   m := 0; 
   init( b[m] );
   for i := 0 to n-1 do begin 
      read( a[i].visina );
      push_back( b[m], i );
      if b[m].size = BLOCK_SIZE then begin
         m := m + 1;
         init( b[m] );
      end;
   end;

   for q := 1 to s do begin
      readln;
      read( start ); start := start - 1;
      read( c ); read( c );
      read( k );

      i := start div BLOCK_SIZE;
      j := (b[i].pocetak + (start mod BLOCK_SIZE)) and MODULO;

      ret := -inf;
      if c = 'D' then begin        

         while (k > 0) and (j <> b[i].kraj) do begin   (* setnja do kraja bloka *)
            jj := (j+1) and MODULO;
            swap( b[i].lista[j], b[i].lista[jj] );
            maxi( ret, a[b[i].lista[j]].visina );
            j := jj;
            k := k - 1;
         end;
         if k > 0 then begin   (* skokovi po blokovima *)
            k := k - 1;
            x := pop_back( b[i] );
           
            while k >= BLOCK_SIZE do begin
               maxi( ret, max( b[i+1] ) );
               push_back( b[i], pop_front( b[i+1] ) );
               i := i + 1;
               k := k - BLOCK_SIZE;
            end;

            maxi( ret, a[front(b[i+1])].visina );
            push_back( b[i], pop_front( b[i+1] ) );
            i := i + 1;

            push_front( b[i], x );
            j := b[i].pocetak;
         end;

         while (k > 0) and (j <> b[i].kraj) do begin   (* setnja do konacne pozicije *)
            jj := (j+1) and MODULO;
            swap( b[i].lista[j], b[i].lista[jj] );
            maxi( ret, a[b[i].lista[j]].visina );
            j := jj;
            k := k - 1;
         end;

      end else begin

         while (k > 0) and (j <> b[i].pocetak) do begin   (* setnja do pocetka bloka *)
            jj := (j-1) and MODULO;
            swap( b[i].lista[j], b[i].lista[jj] );
            maxi( ret, a[b[i].lista[j]].visina );
            j := jj;
            k := k - 1;
         end;

         if k > 0 then begin   (* skokovi po blokovima *)
            k := k - 1;
            x := pop_front( b[i] );
           
            while k >= BLOCK_SIZE do begin
               maxi( ret, max( b[i-1] ) );
               push_front( b[i], pop_back( b[i-1] ) );
               i := i - 1;
               k := k - BLOCK_SIZE;
            end;

            maxi( ret, a[back(b[i-1])].visina );
            push_front( b[i], pop_back( b[i-1] ) );
            i := i - 1;

            push_back( b[i], x );
            j := b[i].kraj;
         end;

         while (k > 0) and (j <> b[i].pocetak) do begin   (* setnja do konacne pozicije *)
            jj := (j-1) and MODULO;
            swap( b[i].lista[j], b[i].lista[jj] );
            maxi( ret, a[b[i].lista[j]].visina );
            j := jj;
            k := k - 1;
         end;

      end;

      writeln( ret );      
   end;
end.
