
(*
  Izborne pripreme 2007
  Zadatak POVEZ
*)

program povez;

const maxn = 500;

type par = record
              first, second : longint;
           end;

var
   n           : longint;
   incomingcnt : array[0..maxn-1, 0..1] of longint;
   incoming    : array[0..maxn-1, 0..1, 0..maxn-1] of longint;
   jump        : array[0..maxn-1, 0..1] of longint;
   bio         : array[0..maxn-1, 0..maxn-1] of boolean;
   dad         : array[0..maxn-1, 0..maxn-1] of par;
   kako        : array[0..maxn-1, 0..maxn-1] of longint;
   queue       : array[0..maxn*maxn-1] of par;

function daj_par(a, b : longint):par;
begin
   daj_par.first := a;
   daj_par.second := b;
end;

procedure bfs;
var
   qfront, qend, dig, i, j : longint;
   p, next                 : par;
begin                          
   bio[0, 0] := true;
   qfront := 0; qend := 0;
   
   queue[qend] := daj_par(0, 0); qend := qend+1;
   while qfront < qend do begin
      p := queue[qfront]; qfront := qfront+1;

      for dig:=0 to 1 do
         for i:=0 to incomingcnt[p.first, dig]-1 do
            for j:=0 to incomingcnt[p.second, dig]-1 do begin
               next := daj_par(incoming[p.first, dig, i], incoming[p.second, dig, j]);
               if bio[next.first, next.second] then continue;
               bio[next.first, next.second] := true;
               dad[next.first, next.second] := p;
               kako[next.first, next.second] := dig;
               queue[qend] := next; qend := qend+1;
            end;
   end;
end;

procedure sortunique(var S:array of longint; var cnt:longint);
var
   i, j, t, skip : longint;
begin
   for i:=1 to cnt-1 do begin
      t := S[i];
      j := i;
      while (j > 0) and (t < S[j-1]) do begin
         S[j] := S[j-1];
         j := j-1;
      end;
      S[j] := t;
   end;

   skip := 0;
   for i:=1 to cnt-1 do begin
      if S[i] <> S[i-1] then
         S[i-skip] := S[i]
      else
         skip := skip+1;
   end;

   cnt := cnt-skip;
end;

var
   i, a, b : longint;
   S       : array[0..maxn-1] of longint;
   Scnt    : longint;
   p       : par;

begin
   readln(n);
   for i:=0 to n-1 do begin
      readln(a, b);
      a := a-1; b := b-1;
      jump[i, 0] := a;
      jump[i, 1] := b;
      incoming[a, 0, incomingcnt[a, 0]] := i; incomingcnt[a, 0] := incomingcnt[a, 0] + 1;
      incoming[b, 1, incomingcnt[b, 1]] := i; incomingcnt[b, 1] := incomingcnt[b, 1] + 1;
   end;

   bfs;

   Scnt := n;
   for i:=0 to n-1 do
      S[i] := i;

   while Scnt > 1 do begin
      if not bio[S[0], S[1]] then begin
         writeln('Nema rjesenja!?');
         exit;
      end;

      p := daj_par( S[0], S[1] );
      while (p.first <> 0) or (p.second <> 0) do begin
         write(chr(ord('A') + kako[p.first, p.second]));
         for i:=0 to Scnt-1 do
            S[i] := jump[S[i], kako[p.first, p.second]];

         p := dad[p.first, p.second];
      end;

      sortunique(S, Scnt);
   end;

   writeln;
end.
