
/*
  Izborne pripreme 2007
  Zadatak TORNJEVI
*/

#include <algorithm>
#include <cstdio>
#include <vector>

using namespace std;

typedef pair<int,int> par;

#define MAX 100

int n;
int rr[MAX*MAX], ss[MAX*MAX];
vector<par> adj[2*MAX*MAX][2];

int R, S;
char ulaz[MAX][MAX+1];

int broj[MAX][MAX];
int nadji[MAX][MAX][4];

int cookie[2*MAX*MAX], COOKIE;
char valid_cookie[4*MAX*MAX+2];
int var[2*MAX*MAX];

int dfs( int X, int x ) {
   if( valid_cookie[cookie[X]] ) return var[X] == x;
   cookie[X] = COOKIE;
   var[X] = x;

   x ^= 1;
   for( vector<par>::iterator it = adj[X][x].begin(); it != adj[X][x].end(); ++it ) 
      if( !dfs( it->first, it->second ) )
         return 0;
   return 1;
}

int main( void ) {
   scanf( "%d%d", &R, &S );
   for( int r = 0; r < R; ++r ) {
      scanf( "%s", ulaz[r] );
      for( int s = 0; s < S; ++s ) {
         if( ulaz[r][s] == 'T' ) {
            rr[n] = r;
            ss[n] = s;
            broj[r][s] = n++;
         }
      }
   }
   
   memset( nadji, -1, sizeof nadji );

   for( int r = 0; r < R; ++r ) 
      for( int s = 0; s < S; ++s ) {
         if( ulaz[r][s] == '#' ) continue;
         if( r-1 >= 0 ) nadji[r][s][0] = ulaz[r-1][s] == 'T' ? broj[r-1][s] : nadji[r-1][s][0];
         if( s-1 >= 0 ) nadji[r][s][1] = ulaz[r][s-1] == 'T' ? broj[r][s-1] : nadji[r][s-1][1];
      }
   for( int r = R-1; r >= 0; --r ) 
      for( int s = S-1; s >= 0; --s ) {
         if( ulaz[r][s] == '#' ) continue;
         if( r+1 < R ) nadji[r][s][2] = ulaz[r+1][s] == 'T' ? broj[r+1][s] : nadji[r+1][s][2];
         if( s+1 < S ) nadji[r][s][3] = ulaz[r][s+1] == 'T' ? broj[r][s+1] : nadji[r][s+1][3];
      }
       
   try {
      memset( cookie, 0, sizeof cookie );
      memset( valid_cookie, 1, sizeof valid_cookie );
      valid_cookie[0] = 0;
      COOKIE = 1;
      for( int r = 0; r < R; ++r ) {
         for( int s = 0; s < S; ++s ) {
            if( ulaz[r][s] == 'T' ) {
               int x = broj[r][s];

               if( nadji[r][s][0] != -1 && nadji[r][s][2] != -1 ) throw 1;
               if( nadji[r][s][1] != -1 && nadji[r][s][3] != -1 ) throw 1;

               if( nadji[r][s][0] != -1 ) { var[2*x+0] = 1; cookie[2*x+0] = COOKIE; }
               if( nadji[r][s][1] != -1 ) { var[2*x+1] = 1; cookie[2*x+1] = COOKIE; }
               if( nadji[r][s][2] != -1 ) { var[2*x+0] = 0; cookie[2*x+0] = COOKIE; }
               if( nadji[r][s][3] != -1 ) { var[2*x+1] = 0; cookie[2*x+1] = COOKIE; }
            }
            if( ulaz[r][s] == 'x' || ulaz[r][s] == 'n' ) {
               int V = nadji[r][s][0], v = 1; if( V == -1 ) { V = nadji[r][s][2]; v = 0; }
               int H = nadji[r][s][1], h = 1; if( H == -1 ) { H = nadji[r][s][3]; h = 0; }

               if( V == -1 && H == -1 ) throw 1;
               if( V == -1 && H != -1 ) { var[2*H+1] = h; cookie[2*H+1] = COOKIE; }
               if( V != -1 && H == -1 ) { var[2*V+0] = v; cookie[2*V+0] = COOKIE; } 
               if( V != -1 && H != -1 ) {
                  adj[2*H+1][h].push_back( par( 2*V+0, v ) );
                  adj[2*V+0][v].push_back( par( 2*H+1, h ) );
               }
            }
         }
      }

      for( int i = 0; i < 2*n; ++i ) {
         if( valid_cookie[cookie[i]] ) continue;
         
         ++COOKIE;
         if( dfs( i, 0 ) ) continue;
         valid_cookie[COOKIE] = 0;

         ++COOKIE;
         if( dfs( i, 1 ) ) continue;
         valid_cookie[COOKIE] = 0;

         throw 1;
      }

      for( int i = 0; i < n; ++i ) {
         if( var[2*i] == 0 && var[2*i+1] == 0 ) ulaz[rr[i]][ss[i]] = '4';
         if( var[2*i] == 0 && var[2*i+1] == 1 ) ulaz[rr[i]][ss[i]] = '3';
         if( var[2*i] == 1 && var[2*i+1] == 0 ) ulaz[rr[i]][ss[i]] = '1';
         if( var[2*i] == 1 && var[2*i+1] == 1 ) ulaz[rr[i]][ss[i]] = '2';
      }

      for( int r = 0; r < R; ++r ) printf( "%s\n", ulaz[r] );

   } catch( ... ) {
      printf( "NEMA\n" );
   }

   return 0;
}
