
(*
  Izborne pripreme 2007
  Zadatak TORNJEVI
*)

program tornjevi;

const maxn = 100;

var
   n, R, S      : longint;
   rr, ss       : array[1..maxn*maxn] of longint;
   ulaz         : array[1..maxn] of string;
   broj         : array[1..maxn, 1..maxn] of longint;
   najblizi     : array[1..maxn, 1..maxn, 0..3] of longint;
   cookie       : array[0..2*maxn*maxn] of longint;
   sadcookie    : longint;
   valid_cookie : array[0..4*maxn*maxn+1] of boolean;
   vari         : array[0..2*maxn*maxn] of boolean;
   adjcnt       : array[0..2*maxn*maxn, false..true] of longint;
   adjvar       : array[0..2*maxn*maxn, false..true, 1..maxn] of longint;
   adjvri       : array[0..2*maxn*maxn, false..true, 1..maxn] of boolean;

function dfs(varijabla : longint; vrijednost : boolean):boolean;
var i : longint;
begin
   if valid_cookie[cookie[varijabla]] then begin
      dfs := vari[varijabla] = vrijednost;
      exit;
   end;

   cookie[varijabla] := sadcookie;
   vari[varijabla] := vrijednost;

   vrijednost := not vrijednost;
   for i:=1 to adjcnt[varijabla, vrijednost] do
      if not dfs(adjvar[varijabla, vrijednost, i], adjvri[varijabla, vrijednost, i]) then begin
         dfs := false;
         exit;
      end;

   dfs := true;
end;

var
   i, j, k, x : longint;
   V, H       : longint;
   vvar, hvar : boolean;
                
begin
   n := 0;
   readln(R, S);
   for i:=1 to R do begin
      readln(ulaz[i]);
      for j:=1 to S do begin
         if ulaz[i, j] = 'T' then begin
            rr[n] := i;
            ss[n] := j;
            broj[i, j] := n;
            n := n+1;
         end;
      end;
   end;

   for i:=1 to R do 
      for j:=1 to S do
         for k:=0 to 3 do
            najblizi[i, j, k] := -1;

   for i:=1 to R do begin
      for j:=1 to S do begin
         if ulaz[i, j] = '#' then continue;
         if i > 1 then begin
            if ulaz[i-1, j] = 'T' then
               najblizi[i, j, 0] := broj[i-1, j]
            else
               najblizi[i, j, 0] := najblizi[i-1, j, 0];
         end;

         if j > 1 then begin
            if ulaz[i, j-1] = 'T' then
               najblizi[i, j, 1] := broj[i, j-1]
            else
               najblizi[i, j, 1] := najblizi[i, j-1, 1];
         end;
      end;
   end;

   for i:=R downto 1 do begin
      for j:=S downto 1 do begin
         if ulaz[i, j] = '#' then continue;
         if i < R then begin
            if ulaz[i+1, j] = 'T' then
               najblizi[i, j, 2] := broj[i+1, j]
            else
               najblizi[i, j, 2] := najblizi[i+1, j, 2];
         end;

         if j < S then begin
            if ulaz[i, j+1] = 'T' then
               najblizi[i, j, 3] := broj[i, j+1]
            else
               najblizi[i, j, 3] := najblizi[i, j+1, 3];
         end;
      end;
   end;

   for i:=0 to 2*n-1 do begin
      cookie[i] := 0;
      valid_cookie[i] := true;
   end;
   valid_cookie[0] := false;
   sadcookie := 1;

   for i:=1 to R do begin
      for j:=1 to S do begin
         if ulaz[i, j] = 'T' then begin
            x := broj[i, j];

            if ((najblizi[i, j, 0] <> -1) and (najblizi[i, j, 2] <> -1)) or
               ((najblizi[i, j, 1] <> -1) and (najblizi[i, j, 3] <> -1)) then begin
               writeln('NEMA');
               exit;
            end;

            if najblizi[i, j, 0] <> -1 then begin vari[2*x+0] := true;  cookie[2*x+0] := sadcookie; end;
            if najblizi[i, j, 1] <> -1 then begin vari[2*x+1] := true;  cookie[2*x+1] := sadcookie; end;
            if najblizi[i, j, 2] <> -1 then begin vari[2*x+0] := false; cookie[2*x+0] := sadcookie; end;
            if najblizi[i, j, 3] <> -1 then begin vari[2*x+1] := false; cookie[2*x+1] := sadcookie; end;
         end;
         if (ulaz[i, j] = 'x') or (ulaz[i, j] = 'n') then begin
            V := najblizi[i, j, 0]; vvar := true; if V = -1 then begin V := najblizi[i, j, 2]; vvar := false; end;
            H := najblizi[i, j, 1]; hvar := true; if H = -1 then begin H := najblizi[i, j, 3]; hvar := false; end;

            if (V =  -1) and (H =  -1) then begin writeln('NEMA'); exit; end;
            if (V =  -1) and (H <> -1) then begin vari[2*H+1] := hvar; cookie[2*H+1] := sadcookie; end;
            if (V <> -1) and (H =  -1) then begin vari[2*V+0] := vvar; cookie[2*V+0] := sadcookie; end;
            if (V <> -1) and (H <> -1) then begin
               adjcnt[2*H+1, hvar] := adjcnt[2*H+1, hvar] + 1;
               adjvar[2*H+1, hvar, adjcnt[2*H+1, hvar]] := 2*V+0;
               adjvri[2*H+1, hvar, adjcnt[2*H+1, hvar]] := vvar;

               adjcnt[2*V+0, vvar] := adjcnt[2*V+0, vvar] + 1;
               adjvar[2*V+0, vvar, adjcnt[2*V+0, vvar]] := 2*H+1;
               adjvri[2*V+0, vvar, adjcnt[2*V+0, vvar]] := hvar;
            end;
         end;
      end;
   end;

   for i:=0 to 2*n-1 do begin
      if valid_cookie[cookie[i]] then continue;

      sadcookie := sadcookie+1;
      if dfs(i, false) then continue;
      valid_cookie[sadcookie] := false;
      
      sadcookie := sadcookie+1;
      if dfs(i, true) then continue;
      valid_cookie[sadcookie] := false;

      writeln('NEMA');
      exit;
   end;

   for i:=0 to n-1 do begin
      if not vari[2*i] and not vari[2*i+1] then ulaz[rr[i], ss[i]] := '4';
      if not vari[2*i] and     vari[2*i+1] then ulaz[rr[i], ss[i]] := '3';
      if     vari[2*i] and not vari[2*i+1] then ulaz[rr[i], ss[i]] := '1';
      if     vari[2*i] and     vari[2*i+1] then ulaz[rr[i], ss[i]] := '2';
   end;

   for i:=1 to R do
      writeln(ulaz[i]);
end.
