
/*
  Izborne pripreme 2007
  Zadatak NOGA
*/

#include <algorithm>
#include <cstdio>

#define BLOCKS 100
#define BLOCK_SIZE 1000
#define MOD 1023

using namespace std;

const int inf = 1000000000;

struct skakavac {
   int visina;
   int gdje;
} a[BLOCKS*BLOCK_SIZE];

struct blok {
   int size;
   int heap[MOD+1];
   int lista[MOD+1], pocetak, kraj;

   blok() { 
      size = 0;
      pocetak = 0; 
      kraj = MOD; 
   }

   void up_heap( int i ) {
      int t = heap[i];
      while( i > 1 ) {
         int j = i>>1;
         if( a[heap[j]].visina >= a[t].visina ) break;

         heap[i] = heap[j]; a[heap[i]].gdje = i;
         i = j;
      }
      heap[i] = t; a[heap[i]].gdje = i;
   }
   void down_heap( int i ) {
      int t = heap[i];
      while( (i<<1) <= size ) {
         int j = i<<1;
         if( j+1 <= size && a[heap[j+1]].visina > a[heap[j]].visina ) ++j;
         if( a[t].visina >= a[heap[j]].visina ) break;

         heap[i] = heap[j]; a[heap[i]].gdje = i;
         i = j;         
      }
      heap[i] = t; a[heap[i]].gdje = i;
   }
   void heap_insert( int x ) {
      ++size;
      heap[size] = x; a[heap[size]].gdje = size;
      up_heap( size );
   }
   void heap_erase( int x ) {
      heap[a[x].gdje] = heap[size--];
      if( size ) {
         up_heap( a[x].gdje );
         down_heap( a[x].gdje );
      }
   }

   int pop_front() { 
      int ret = lista[pocetak];
      pocetak = (pocetak+1) & MOD;
      heap_erase( ret );
      return ret;
   }
   int pop_back() {
      int ret = lista[kraj];
      kraj = (kraj-1) & MOD;
      heap_erase( ret );
      return ret;
   }
   void push_front( int x ) {
      heap_insert( x );
      pocetak = (pocetak-1)&MOD;
      lista[pocetak] = x;      
   }
   void push_back( int x ) {
      heap_insert( x );
      kraj = (kraj+1)&MOD;
      lista[kraj] = x;      
   }

   int max() { return size == 0 ? -inf : a[heap[1]].visina; }
   int front() { return lista[pocetak]; }
   int back() { return lista[kraj]; }

} b[BLOCKS];

int main( void ) {
   int n, s;
   scanf( "%d%d", &n, &s );
   
   int m = 0;
   for( int i = 0; i < n; ++i ) {
      scanf( "%d", &a[i].visina );
      b[m].push_back( i );
      if( b[m].size == BLOCK_SIZE ) ++m;
   }

   for( int q = 0; q < s; ++q ) {
      int start, k;
      char c;
      scanf( "%d %c %d", &start, &c, &k ); --start;

      int i = start / BLOCK_SIZE;
      int j = (b[i].pocetak + start % BLOCK_SIZE) & MOD;

      int ret = -inf;
      if( c == 'D' ) { 
         
         for( ; k && j != b[i].kraj; --k ) { // setnja do kraja bloka
            int jj = (j+1) & MOD;
            swap( b[i].lista[j], b[i].lista[jj] );
            ret >?= a[b[i].lista[j]].visina;
            j = jj;
         }
         if( k ) { // skokovi po blokovima
            --k;
            int x = b[i].pop_back();
            for( ; k >= BLOCK_SIZE; k -= BLOCK_SIZE ) {
               ret >?= b[i+1].max();
               b[i].push_back( b[i+1].pop_front() );
               ++i;
            }
            ret >?= a[b[i+1].front()].visina;
            b[i].push_back( b[i+1].pop_front() );

            ++i;
            b[i].push_front( x );
            j = b[i].pocetak;
         }
         for( ; k && j != b[i].kraj; --k ) { // setnja do konacne pozicije
            int jj = (j+1) & MOD;
            swap( b[i].lista[j], b[i].lista[jj] );
            ret >?= a[b[i].lista[j]].visina;
            j = jj;
         }         

      } else { 

         for( ; k && j != b[i].pocetak; --k ) { // setnja do pocetka bloka
            int jj = (j-1) & MOD;
            swap( b[i].lista[j], b[i].lista[jj] );
            ret >?= a[b[i].lista[j]].visina;
            j = jj;
         }
         if( k ) { // skokovi po blokovima
            --k;
            int x = b[i].pop_front();
            for( ; k >= BLOCK_SIZE; k -= BLOCK_SIZE ) {
               ret >?= b[i-1].max();
               b[i].push_front( b[i-1].pop_back() );
               --i;
            }
            ret >?= a[b[i-1].back()].visina;
            b[i].push_front( b[i-1].pop_back() );

            --i;
            b[i].push_back( x );
            j = b[i].kraj;
         }
         for( ; k && j != b[i].pocetak; --k ) { // setnja do konacne pozicije
            int jj = (j-1) & MOD;
            swap( b[i].lista[j], b[i].lista[jj] );
            ret >?= a[b[i].lista[j]].visina;
            j = jj;
         }         

      }
      printf( "%d\n", ret );
   }

   return 0;
}
