
/*
  Izborne pripreme 2007
  Zadatak POVEZ
*/

#include <algorithm>
#include <cstdio>
#include <queue>

using namespace std;

typedef pair<int,int> par;

#define MAXN 500

int n;

vector<int> incoming[MAXN][2];

int jump[MAXN][2];
char bio[MAXN][MAXN];
par dad[MAXN][MAXN];
char how[MAXN][MAXN];

void bfs() {
   bio[0][0] = 1;
   queue<par> Q;
   for( Q.push( par(0,0) ); !Q.empty(); Q.pop() ) {
      par p = Q.front();

      for( int dig = 0; dig < 2; ++dig ) 
         for( vector<int>::iterator it = incoming[p.first][dig].begin(); it != incoming[p.first][dig].end(); ++it ) 
            for( vector<int>::iterator jt = incoming[p.second][dig].begin(); jt != incoming[p.second][dig].end(); ++jt ) {
               if( bio[*it][*jt] ) continue;
               bio[*it][*jt] = 1;
               dad[*it][*jt] = p;
               how[*it][*jt] = dig;
               Q.push( par(*it,*jt) );
            }
   }
}

int main( void ) {
   scanf( "%d", &n );
   for( int i = 0; i < n; ++i ) {
      scanf( "%d%d", &jump[i][0], &jump[i][1] ); --jump[i][0]; --jump[i][1];
      incoming[jump[i][0]][0].push_back( i );
      incoming[jump[i][1]][1].push_back( i );
   }

   bfs();

   vector<int> S;
   for( int i = 0; i < n; ++i ) S.push_back( i );

   while( S.size() > 1 ) {
      if( !bio[S[0]][S[1]] ) { printf( "Nema rjesenja!?" ); break; }

      for( par p( S[0], S[1] ); p != par(0,0); p = dad[p.first][p.second] ) {

         printf( "%c", 'A' + how[p.first][p.second] );
         for( vector<int>::iterator it = S.begin(); it != S.end(); ++it ) 
            *it = jump[*it][how[p.first][p.second]];         
      }

      sort( S.begin(), S.end() ); 
      S.erase( unique( S.begin(), S.end() ), S.end() );
   }
   printf( "\n" );

   return 0;
}
