program arhitekt;

uses classes;

const dx : array[0..7] of integer = ( 0, -1, -1, -1, 0, 1, 1, 1 );
const dy : array[0..7] of integer = ( 1, 1, 0, -1, -1, -1, 0, 1 );

type
   pNode = ^Node;
   pEdge = ^Edge;
   Node = record 
      x, y : longint;
   end;   
   Edge = record
      a, b : Node;
   end;
   
function cmpNode( P, Q : pointer ) : longint;
var
   pp, qq : pNode;
begin
   pp := P;
   qq := Q;
   if pp^.x <> qq^.x then 
      cmpNode := pp^.x - qq^.x 
   else 
      cmpNode := pp^.y - qq^.y;
end;

function cmpEdge( P, Q : pointer ) : longint;
var
   pp, qq : pEdge;
begin
   pp := P;
   qq := Q;
   if cmpNode( @pp^.a, @qq^.a ) <> 0 then 
      cmpEdge := cmpNode( @pp^.a, @qq^.a )
   else 
      cmpEdge := cmpNode( @pp^.b, @qq^.b );
end;

var
   i, j, n, ret : longint;
   c : char;
   V, E : TList;
   P, Q : Node;
   vv, vv2 : pNode;
   ee, ee2 : pEdge;
   
begin
   readln( n );

   V := TList.create;
   E := TList.create;
   
   P.x := 0; P.y := 0;   
   new( vv ); vv^.x := P.x; vv^.y := P.y; V.add( vv );
   
   for i := 1 to n do begin
      read( c );
      for j := 1 to 2 do begin
         Q.x := P.x + dx[ord(c) - ord('0')];
         Q.y := P.y + dy[ord(c) - ord('0')];
         
         new( vv ); vv^.x := Q.x; vv^.y := Q.y; V.add( vv );
         new( ee );
         if cmpNode( @P, @Q ) < 0 then begin
            ee^.a := P;
            ee^.B := Q;
         end else begin
            ee^.a := Q;
            ee^.B := P;
         end;
         E.add( ee );
         
         P := Q;
      end;
   end;
   
   V.sort( @cmpNode );
   E.sort( @cmpEdge );
   
   ret := 1;
   for i := 1 to V.count-1 do begin
      vv := V.items[i-1];
      vv2 := V.items[i];
      if cmpNode( vv, vv2 ) <> 0 then ret := ret - 1;      
   end;
   for i := 1 to E.count-1 do begin
      ee := E.items[i-1];
      ee2 := E.items[i];
      if cmpEdge( ee, ee2 ) <> 0 then ret := ret + 1;      
   end;
   writeln( ret );
end.
