program dorucak;

const eps = 1e-9;

type 
   point = record
      x, y : real;
   end;
   pointArray = array[1..5000] of point;

function lt( a, b : real ) : boolean;
begin
   lt := (a + eps < b);
end;
function eq( a, b : real ) : boolean;
begin
   eq := not lt( a, b ) and not lt( b, a );
end;
function cross( A, B, C : point ) : real;
begin
   cross := (B.x-A.x)*(C.y-A.y) - (C.x-A.x)*(B.y-A.y);
end;
function ccw( A, B, C : point ) : longint;
var
   t : real;
begin
   t := cross( A, B, C );
   if lt( t, 0 ) then ccw := -1
   else if lt( 0, t ) then ccw := 1
   else ccw := 0;
end;
function ispod( T : point; A, B : real ) : boolean;
begin
   ispod := lt( T.y, A * T.x + B );
end;
function iznad( T : point; A, B : real ) : boolean;
begin
   iznad := lt( A * T.x + B, T.y ); 
end;

function presjeci( P, R : point; A, B : real ) : point;
begin
   presjeci.x := (P.x*(R.y-P.y) + (R.x-P.x)*(B-P.y)) / ((R.y-P.y)-A*(R.x-P.x));
   presjeci.y := A*presjeci.x + B;
end;

var 
   nL, nR : longint;
   L, R : pointArray;
   A_lo, A_mid, A_hi : real;
   B_lo, B_mid, B_hi : real;
   iter_A, iter_B : longint;

procedure input;
var
   i : longint;
begin
   readln( nL );
   for i := 1 to nL do
      readln( L[i].x, L[i].y );
         
   readln( nR);
   for i := 1 to nR do
      readln( R[i].x, R[i].y );
end;

function cut( burek : pointArray; n : longint; A, B : real ) : real;
var
   i : longint;
   O, P, Q, R : point;
   Pgore, Pdole : real;
begin
   O.x := 0; O.y := B;

   Pgore := 0.0;
   Pdole := 0.0;

   for i := 1 to n do begin
      P := burek[i];
      if i = n then R := burek[1] else R := burek[i+1];      

      if not ispod( P, A, B ) and not iznad( P, A, B ) and not ispod( R, A, B ) and not iznad( R, A, B ) then continue;

      if ispod( P, A, B ) and ispod( R, A, B ) then
         Pdole := Pdole + cross( O, P, R )
      else if iznad( P, A, B ) and iznad( R, A, B ) then
         Pgore := Pgore + cross( O, P, R )
      else begin
         Q := presjeci( P, R, A, B );
         if ispod( P, A, B ) then Pdole := Pdole + cross( O, P, Q ) else Pgore := Pgore + cross( O, P, Q );
         if ispod( R, A, B ) then Pdole := Pdole + cross( O, Q, R ) else Pgore := Pgore + cross( O, Q, R );
      end;
   end;
   cut := abs(Pdole) - abs(Pgore);
end;


begin
   input;
   
   B_lo := -1e6; 
   B_hi := 1e6;
   for iter_B := 1 to 40 do begin
      B_mid := (B_lo+B_hi) / 2;

      A_lo := -2e6;
      A_hi := 2e6;
      for iter_A := 1 to 40 do begin
         A_mid := (A_lo+A_hi) / 2;

         if cut( L, nL, A_mid, B_mid ) < 0 then A_hi := A_mid else A_lo := A_mid;
      end;

      if cut( R, nR, A_mid, B_mid ) < 0 then B_lo := B_mid else B_hi := B_mid;
   end;

   writeln( A_mid:3:3, ' ', B_mid:3:3 );  
end.
