#include <cstdio>
#include <vector>

#define MAX 100000
#define MOD 1000000007

using namespace std;

typedef long long llint;
typedef pair<int,int> par;

int n;
vector<par> adj[MAX];
llint dp[MAX];

inline llint mult( llint a, llint b ) { return a*b % MOD; }
inline llint sum( llint a, llint b ) { return (a+b) % MOD; }

llint dfs( int i, int dad ) {
   llint ret = 0;
   dp[i] = 1;
   for( vector<par>::iterator it = adj[i].begin(); it != adj[i].end(); ++it ) {
      if( it->first == dad ) continue;

      ret = sum(ret, dfs( it->first, i ));
      
      llint podstablo = mult(it->second, dp[it->first]);
      ret = sum(ret, mult(podstablo, dp[i]) );
      dp[i] = sum(dp[i], podstablo);
   }
   return ret;
}

int main( void ) {
   scanf( "%d", &n );
   for( int i = 1; i < n; ++i ) {
      int a, b, c;
      scanf( "%d%d%d", &a, &b, &c ); --a; --b;
      
      adj[a].push_back( par(b,c) );
      adj[b].push_back( par(a,c) );
   }
   
   printf( "%lld\n", dfs( 0, -1 ) );

   return 0;
}
