program putevi;

const MM = 1000000007;

type
   pEdge = ^Edge;
   Edge = record
      u, v : longint;
      cost : longint;
      next : pEdge;
   end;

var    
   i, n : longint;
   head : array[1..100000] of pEdge;
   dp : array[1..100000] of int64;
   u, v, cost : longint;
   
procedure addEdge( u, v, cost : longint );
var
   ee : pEdge;
begin
   new(ee);
   ee^.u := u;
   ee^.v := v;
   ee^.cost := cost;
   ee^.next := head[u];
   head[u] := ee;
end;
 
function mult( a, b : int64 ) : int64;
begin
   mult := (a*b) mod MM;
end;
function sum( a, b : int64 ) : int64;
begin
   sum := (a+b) mod MM;
end;

function dfs( i, dad : longint ) : int64;
var
   ret, podstablo : int64;
   it : pEdge;
begin
   ret := 0;
   dp[i] := 1;
   
   it := head[i];
   while it <> nil do begin
      if it^.v <> dad then begin
         ret := sum(ret, dfs( it^.v, i ));
      
         podstablo := mult(it^.cost, dp[it^.v]);
         ret := sum(ret, mult(podstablo, dp[i]) );
         dp[i] := sum(dp[i], podstablo);
      end;
      
      it := it^.next;
   end;
   
   dfs := ret;
end;

begin
   readln( n );
   
   for i := 1 to n do head[i] := nil;
   
   for i := 1 to n-1 do begin
      readln( u, v, cost );      
      addEdge( u, v, cost );
      addEdge( v, u, cost );
   end;
   
   writeln( dfs( 1, 0 ) );
end.
