#include <cstdio>
#include <set>

using namespace std;

const int MAX = 100000;
const int dx[8] = {0, 1, 1, 1, 0, -1, -1, -1};
const int dy[8] = {1, 1, 0, -1, -1, -1, 0, 1};

struct Node {
   int x, y;
   Node( int X = 0, int Y = 0 ) {
      x = X;
      y = Y;
   }
};
bool operator < ( const Node &A, const Node &B ) {
   if( A.x != B.x ) return A.x < B.x;
   return A.y < B.y;
}
bool operator == ( const Node &A, const Node &B ) {
   return A.x == B.x && A.y == B.y;
}

struct Edge {
   Node a, b;
   Edge( const Node &A, const Node &B ) {
      if( A < B ) {
         a = A;
         b = B;
      } else {
         a = B;
         b = A;
      }
   }
};
bool operator < ( const Edge &A, const Edge &B ) {
   if( !(A.a == B.a) ) return A.a < B.a;
   return A.b < B.b;
}

int n;
char c;

int main() {
   scanf("%d", &n);

   set<Node> nodes;
   set<Edge> edges;
   
   Node p;
   nodes.insert(p);
   for( int i = 0; i < n; ++i ) {
      scanf( " %c", &c );
      for( int j = 0; j < 2; ++j ) {
         Node q( p.x+dx[c-'0'], p.y+dy[c-'0'] );
         nodes.insert(q);
         edges.insert(Edge(p, q));
         p = q;
      }
   }
   
   printf( "%d\n", edges.size()-nodes.size()+1 );
   
   return 0;
}
