#include <cmath>
#include <cstdio>
#include <cstdlib>
#include <vector>

using namespace std;

const double eps = 1e-9;

inline bool lt( double a, double b ) { return a + eps < b; }
inline bool eq( double a, double b ) { return !lt(a,b) && !lt(b,a); }

struct point {
   double x, y;
   point( double X=0, double Y=0 ) { x = X; y = Y; }
};
vector<point> L, R;

double cross( const point &A, const point &B, const point &C ) {
   return (B.x-A.x)*(C.y-A.y) - (C.x-A.x)*(B.y-A.y);
}
int ccw( const point &A, const point &B, const point &C ) {
   double t = cross( A, B, C );
   if( lt( t, 0 ) ) return -1;
   if( lt( 0, t ) ) return 1;
   return 0;
}
bool ispod( const point &T, double A, double B ) { return lt( T.y, A * T.x + B ); }
bool iznad( const point &T, double A, double B ) { return lt( A * T.x + B, T.y ); }

point presjeci( const point &P, const point &R, double A, double B ) {
   double x = (P.x*(R.y-P.y) + (R.x-P.x)*(B-P.y)) / ((R.y-P.y)-A*(R.x-P.x));
   return point( x, A*x+B );
}

void input() {
   for( int iter = 0; iter < 2; ++iter ) {
      int n;
      scanf( "%d", &n );
      for( int i = 0; i < n; ++i ) {
         double x, y;
         scanf( "%lf%lf", &x, &y );

         if( iter == 0 ) L.push_back( point( x, y ) );
         else R.push_back( point( x, y ) );
      }
   }
}

double cut( vector<point> &burek, double A, double B ) {
   point O( 0, B );

   double Pgore = 0.0;
   double Pdole = 0.0;

   for( int i = 0; i < burek.size(); ++i ) {
      point P = burek[i];
      point R = (i+1==burek.size()) ? burek[0] : burek[i+1];

      if( !ispod( P, A, B ) && !iznad( P, A, B ) && !ispod( R, A, B ) && !iznad( R, A, B ) ) continue;

      if( ispod( P, A, B ) && ispod( R, A, B ) ) Pdole += cross( O, P, R );
      else if( iznad( P, A, B ) && iznad( R, A, B ) ) Pgore += cross( O, P, R );
      else {
         point Q = presjeci( P, R, A, B );
         if( ispod( P, A, B ) ) Pdole += cross( O, P, Q ); else Pgore += cross( O, P, Q );
         if( ispod( R, A, B ) ) Pdole += cross( O, Q, R ); else Pgore += cross( O, Q, R );
      }
   }
   return fabs(Pdole) - fabs(Pgore);
}

int main( void ) {
   input();

   double A_mid, B_mid;

   double B_lo = -1e6, B_hi = 1e6;
   for( int iter_B = 0; iter_B < 40; ++iter_B ) {
      B_mid = (B_lo+B_hi) / 2;

      double A_lo = -2e6, A_hi = 2e6;
      for( int iter_A = 0; iter_A < 40; ++iter_A ) {
         A_mid = (A_lo+A_hi) / 2;

         if( cut( L, A_mid, B_mid ) < 0 ) A_hi = A_mid; else A_lo = A_mid;
      }

      if( cut( R, A_mid, B_mid ) < 0 ) B_lo = B_mid; else B_hi = B_mid;
   }

   printf( "%.3lf %.3lf\n", A_mid, B_mid );

   return 0;
}
