#include <algorithm>
#include <cstdio>
#include <vector>

using namespace std;

int n, m;
int bodovi[3300001];
int C[300000], S[300000], B[300000];
int ret[300000];

int tree[8388608];

void generiraj( int i, int lo, int hi ) {
   if( lo == hi ) {
      tree[i] = 1;
   } else {
      int mid = (lo+hi)/2;
      generiraj( 2*i, lo, mid );
      generiraj( 2*i+1, mid+1, hi );
      tree[i] = tree[2*i] + tree[2*i+1];
   }
}

int k_ti( int i, int lo, int hi, int k ) {
   if( lo == hi ) {
      tree[i] = 0;
      return lo;
   } else {
      int mid = (lo+hi)/2, ret;
      
      if( tree[2*i] >= k ) ret = k_ti( 2*i, lo, mid, k );
      else ret = k_ti( 2*i+1, mid+1, hi, k-tree[2*i] );
      
      tree[i] = tree[2*i] + tree[2*i+1];
    
      return ret;
   }
}

int main( void ) {
   scanf( "%d", &n );

   for( int i = 0; i < n; ++i ) scanf( "%d", &C[i] );
   for( int i = 0; i < n; ++i ) scanf( "%d", &S[i] );
   for( int i = 0; i < n; ++i ) scanf( "%d", &B[i] );

   bodovi[0] = 0; bodovi[1] = n;
   for( int i = 0; i < n; ++i ) {
      bodovi[C[i]+1] += 1;
      bodovi[C[i]+S[i]+1] += 3;
      bodovi[C[i]+S[i]+B[i]+1] -= 5;
   }
   for( int i = 1; i <= 3300000; ++i ) bodovi[i] += bodovi[i-1];

   generiraj( 1, 1, 3300000 );

   scanf( "%d", &m );
   for( int i = 0; i < m; ++i ) {
      int h, k;
      scanf( "%d", &h );
      k = k_ti( 1, 1, 3300000, h );
      printf( "%d\n", bodovi[k] );
   }

   return 0;
}
