
/*
Natjecanje studenata informaticara hrvatskih sveucilista 2004
Zadatak LUNAPARK
*/

#include <cstdio>
#include <stack>

using namespace std;

const int inf = 1000000000;

int N;
int V[302][302];
int dr[4] = { -1, 0, 1, 0 };
int ds[4] = { 0, 1, 0, -1 };
int udalj[302][302][4];
bool bb[302][302][4];
struct cvor {
   int r, s, d;
   cvor() {}
   cvor( int rr, int ss, int dd ) { r = rr; s = ss; d = dd; }
   int nagib() { return V[r+dr[d]][s+ds[d]] - V[r][s]; }
   bool & bio() { return bb[r][s][d]; }
   int & best() { return udalj[r][s][d]; }
};
bool susjedi( cvor a, cvor b ) {
   if( b.r+dr[b.d] == a.r && b.s+ds[b.d] == a.s ) return false;
   if( b.nagib() >= max( -a.nagib(), 0 ) ) return false;
   return true;
}

stack<cvor> order;

void dfs( cvor a ) {
   if( a.bio() ) return;
   a.bio() = 1;
   for( int i = 0; i < 4; ++i ) {
      cvor b( a.r+dr[a.d], a.s+ds[a.d], i );
      if( susjedi( a, b ) ) dfs( b );
   }
   order.push( a );
}

int main( void ) {
   scanf( "%d", &N );
   for( int i = 0; i <= N+1; ++i )
      V[i][N+1] = V[N+1][i] = V[0][i] = V[i][0] = inf;
   for( int i = 1; i <= N; ++i )
      for( int j = 1; j <= N; ++j )
         scanf( "%d", &V[i][j] );

   cvor t;
   for( t.r = 1; t.r <= N; ++t.r )
      for( t.s = 1; t.s <= N; ++t.s )
         for( t.d = 0; t.d < 4; ++t.d ) {
            if( t.nagib() < 0 ) {
               dfs( t );
               t.best() = 1;
            } else t.best() = -inf;
         }
   int ret = 0;
   while( !order.empty() ) {
      cvor a = order.top();
      order.pop();
      ret >?= a.best();
      for( int i = 0; i < 4; ++i ) {
         cvor b( a.r+dr[a.d], a.s+ds[a.d], i );
         if( !susjedi( a, b ) ) continue;
         b.best() >?= a.best()+1;
      }
   }
   printf( "%d\n", ret );
   return 0;
}
