
(*
Natjecanje studenata informaticara hrvatskih sveucilista 2004
Zadatak LUNAPARK
*)

(*
  Najdulji put u DAGu -> topolosko sortiranje + dinamicko
  Vremenska slozenost O(N*N) - N je velicina ploce

  Vrhovi grafa su polja ploce sa odredjenim smjerom (redak, stupac, smjer).
  Svaki vrh ima svojstvo nagiba - razliku visina polja. Dva vrha su povezana
  usmjerenim bridom ako su polja susjedna, ako se iz drugog polja ne
  vracamo u prvo polje i ako su zadovoljeni uvjeti sa nagibima (pogledati
  funkciju "susjedi"). Takav graf je usmjereni graf bez ciklusa (DAG).
  Trazi se put najvece duljine. Prvo graf topoloski sortiramo, tj. poredamo
  vrhove u liniju tako da svi bridovi grafa pokazuju prema desno.
  Algoritam za topolosko sortiranje moze se naci u vecini literature za
  pripreme za natjecanja, a temelji se na pretrazivanju u dubinu (mala
  modifikacija DFS-a). Najdulji put se nalazi jednostavnim dinamickim
  algoritmom.
*)

program lunapark;

const INF = 1000000000;

    dr : array[0..3] of longint = ( -1, 0, 1, 0 );
    ds : array[0..3] of longint = ( 0, 1, 0, -1 );
    stacktop : longint = 0;

type cvor=record
          r, s, d : longint; (* redak, stupac, smjer *)
     end;

var n, i, j, ret : longint;
    v : array[0..301, 0..301] of longint;
    udalj : array[0..301, 0..301, 0..3] of longint;
    bio : array[0..301, 0..301, 0..3] of boolean;
    stack : array[0..302*302*4] of cvor;
    t, a, b : cvor;

function nagib(const a : cvor) : longint;
begin
    nagib:= V[a.r+dr[a.d], a.s+ds[a.d]] - V[a.r, a.s];
end;

function max(a, b : longint) : longint;
begin
    if a>=b then max:=a else max:=b;
end;

function susjedi(const a, b : cvor) : boolean;
begin
   if (b.r+dr[b.d]=a.r)and(b.s+ds[b.d]=a.s) then susjedi:=false
   else if nagib(b)>=max(-nagib(a), 0) then susjedi:=false
   else susjedi:=true;
end;

procedure dfs(a : cvor);
var i : longint;
    b : cvor;
begin
   if bio[a.r, a.s, a.d] then exit;
   bio[a.r, a.s, a.d] := true;
   for i := 0 to 3 do
   begin
      b.r:=a.r+dr[a.d];
      b.s:=a.s+ds[a.d];
      b.d:=i;
      if susjedi(a, b) then dfs(b);
   end;
   stack[stacktop]:=a;
   inc(stacktop);
end;

begin
    readln(n);
    for i:=0 to n+1 do
    begin
        V[i, N+1]:=inf;
        V[N+1, i]:=inf;
        V[0, i]:=inf;
        V[i, 0]:=inf;
    end;
    for i:=1 to n do
      for j:=1 to n do read(v[i, j]);

   for t.r:=1 to n do
      for t.s:=1 to n do
         for t.d:=0 to 3 do if nagib(t)<0 then
         begin
             dfs(t);
             udalj[t.r, t.s, t.d] := 1;
         end else udalj[t.r, t.s, t.d] := -inf;

   ret := 0;
   while (stacktop>0)do
   begin
      dec(stacktop);
      a := stack[stacktop];
      if udalj[a.r, a.s, a.d]>ret then ret:=udalj[a.r, a.s, a.d];
      for i:=0 to 3 do
      begin
         b.r:=a.r+dr[a.d];
         b.s:=a.s+ds[a.d];
         b.d:=i;
         if not(susjedi(a, b)) then continue;
         if udalj[b.r, b.s, b.d]<=udalj[a.r, a.s, a.d] then
            udalj[b.r, b.s, b.d]:=udalj[a.r, a.s, a.d]+1;
      end;
   end;
   writeln(ret);
end.
