
(*
Natjecanje studenata informaticara hrvatskih sveucilista 2004
Zadatak NOSOROG
*)

(*
    Zadatak se rjesava isprobavanjem svih mogucnosti: pokusavamo redom
    ispisati sva slova tako da pobrisemo sva slova prije trazenog. Pitanje
    je samo da li da uzmemo prvo slovo s lijeve strane, ili da okrenemo
    cijeli niz znakova, pa da uzmemo prvo slovo s druge strane. Rekurzijom
    isprobamo obe mogucnosti. Kako imamo samo 7 slova, broj mogucnosti je
    u najgorem slucaju 2^7=128.
    Slozenost: linearna duljini niza.
*)

program nosorog;

const DES = 1;
      LIJ = 2;
      slova : array[0..7] of char = ( 'N', 'O', 'S', 'O', 'R', 'O', 'G', '?' );
      rjlen : longint = 0;          (* duljina rjesenja *)

var   s : string[130];              (* ulazni string *)
      rj : array[0..600] of char;  (* rjesenje *)

function nadji(slovo : char; lijevo, desno, dubina, smjer : longint) : boolean;
var gdje, dodano, i : longint;
begin
    if dubina=7 then
    begin
        nadji:=true;
        exit;
    end;
    gdje:=desno+1;
    for i:=lijevo to desno do if s[i]=slovo then
    begin
        gdje:=i;
        break;
    end;
    if gdje<=desno then
        if nadji(slova[dubina+1], gdje, desno, dubina+1, DES) then
        begin
            dodano := gdje-lijevo + 1;
            if smjer=LIJ then dodano:=dodano+1;
            rjlen:=rjlen+dodano;
            if smjer=LIJ then
            begin
                rj[rjlen-1]:='O';
                for i:=1 to dodano-2 do rj[rjlen-i-1]:='B';
            end else
                for i:=0 to dodano-2 do rj[rjlen-i-1]:='B';
            rj[rjlen-dodano]:='P';
            nadji:=true;
            exit;
        end;
    gdje:=lijevo-1;
    for i:=desno downto lijevo do if s[i]=slovo then
    begin
        gdje:=i;
        break;
    end;
    if gdje>=lijevo then
        if nadji(slova[dubina+1], lijevo, gdje, dubina+1, LIJ) then
        begin
            dodano := desno-gdje + 1;
            if smjer=DES then dodano:=dodano+1;
            rjlen:=rjlen+dodano;
            if smjer=DES then
            begin
                rj[rjlen-1]:='O';
                for i:=1 to dodano-2 do rj[rjlen-i-1]:='B';
            end else
                for i:=0 to dodano-2 do rj[rjlen-i-1]:='B';
            rj[rjlen-dodano]:='P';
            nadji:=true;
            exit;
        end;
    nadji:=false;
end;

procedure ispisi_rjesenje;
var i : longint;
begin
    for i:=0 to rjlen-1 do write(rj[rjlen-i-1]);
    writeln;
end;

begin
    readln(s);
    nadji('N', 1, length(s), 0, DES);
    ispisi_rjesenje;
end.
