
/*
Natjecanje studenata informaticara hrvatskih sveucilista 2004
Zadatak TOCKE
*/

#include <cstdio>
#include <stack>

using namespace std;

int N;
int g[1000][1000];
int indegree[1000];
int outdegree[1000];

stack< pair<int, int> > rjesenje;

void eulerova_tura( int x ) {
   for( int i = 0; i < 1000; ++i ) {
      if( g[x][i] ) {
         g[x][i] = 0;
         eulerova_tura( i );
         rjesenje.push( pair<int,int> (i, x) );
      }
   }
}

int main( void ) {
   scanf( "%d", &N );
   for( int i = 0; i < N; ++i ) {
      int x, y;
      scanf( "%d%d", &x, &y ); x--; y--;
      g[y][x] = 1;
      indegree[x]++;
      outdegree[y]++;
   }
   int start = 0;
   for( int i = 0; i < 1000; ++i )
      if( indegree[i] < outdegree[i] ) start = i;

   eulerova_tura( start );

   while( !rjesenje.empty() ) {
      printf( "%d %d\n", rjesenje.top().first + 1, rjesenje.top().second + 1 );
      rjesenje.pop();
   }

   return 0;
}
