
(*
Natjecanje studenata informaticara hrvatskih sveucilista 2004
Zadatak TOCKE
*)

(*
    Sve koordinate koje se pojavljuju mozemo shvatiti kao vrhove grafa,
    a sve tocke (x, y) kao usmjerene bridove koji povezuju vrhove x i y.
    Problem je obici sve bridove tocno jednom, a taj obilazak je poznat
    pod imenom "Eulerova tura". Ulazni/izlazni stupanj vrha "v" je broj
    bridova koji ulaze/izlaze iz njega. Oznacavamo ih sa indeg[v] i
    outdeg[v]. Pretpostavka je da ce rjesenje postojati, ali pokazuje se
    da tura uvijek postoji ako za svaki vrh vrijedi indeg[v]=outdeg[v].
    Kad god udjemo u neki vrh, iz njega moramo i izaci, pa ce za sve vrhove
    osim za pocetnog i zavrsnog vrijediti indeg[v]=outdeg[v].
    Ako za neki vrh vrijedi indeg[v]<outdeg[v] onda sigurno moramo poceti u
    tom vrhu, a ako je za sve vrhove indeg[v]=outdeg[v], onda je svejedno
    u kojem vrhu pocnemo. Turu trazimo slijedecim algoritmom:
    Rekurzijom se secemo iz vrha u vrh birajuci bilo koji brid, koji zatim
    "brisemo". Na kraju cemo zavrsiti u vrhu za kojeg je na pocetku vrijedilo
    outdeg[v]<indeg[v], a ako takvog nije bilo, onda cemo zavrsiti u istom
    vrhu iz kojeg smo krenuli. Moze se desiti da u tom trenutku jos preostaje
    neki dio grafa koji treba obici, ili nekoliko dijelova. Svaki od tih
    dijelova zadovoljava indeg[v]=outdeg[v], pa ih je moguce obici na isti
    nacin i ubaciti taj dodatni obilazak na odgovarajuce mjesto dijela ture
    kojeg smo vec pronasli. To se izvodi u svakom koraku rekurzije prije
    izlaska.

    Vremenska slozenost opcenite Eulerove ture je O(N) (N je broj bridova),
    a broj koraka ove implementacije je N*1000.
*)

program tocke;
var n, i, x, y, start : longint;
    g : array[1..1000, 1..1000] of boolean;
    indeg, outdeg : array[1..1000] of longint;

procedure eulerova_tura(x : longint);
var i : longint;
begin
   for i:=1 to 1000 do
      if g[x, i] then
      begin
         g[x, i] := false;
         eulerova_tura(i);
         writeln(x, ' ', i);
      end;
end;

begin
   readln(n);
   for i:=1 to n do
   begin
      readln(y, x);
      g[y, x] := true;
      inc(indeg[x]);
      inc(outdeg[y]);
   end;

   start := 1;
   for i:=1 to 1000 do
      if indeg[i]<outdeg[i] then start:=i;

   eulerova_tura(start);
end.
