
/*
   January 2003 Monthly Contest - Problem C. Critical Wave
   Team 2. - Kalinovcic, Dondjivic, Kokan
*/

#include <stdio.h>
#include <stdlib.h>

int n, rez;
struct point{ int x, y; } p[1024];
int moguca_os[70000];

inline int cmp( const void *e1, const void *e2 ) {
   return ((struct point *)e1)->x - ((struct point *)e2)->x;
}

int input() {
   int i;
   for( i = 0; i < 70000; ++i ) moguca_os[i] = 0;
   if( scanf( "%d", &n ) != 1 ) return 0;
   for( i = 0; i < n; ++i ) {
      scanf( "%d%d", &p[i].x, &p[i].y );
      p[i].y += 35000;
      moguca_os[p[i].y+1] = 1;
      moguca_os[p[i].y-1] = 1;
   }
   qsort( (void *)p, n, sizeof p[0], cmp );
   p[n].x = -1000000;
   return 1;
}

int probaj_os( int y, int delta ) {
   int c = 0, j;
   for( j = 0; j < n; ++j )
      if( p[j].y == y + delta ) {
         c++; delta *= -1;
         for( ; p[j+1].x == p[j].x; ++j );
      }
   return c;
}

void solve() {
   int i, c;
   for( i = 0; i < 70000; ++i ) {
      if( !moguca_os[i] ) continue;
      c = probaj_os( i, 1 );
      if( c > rez ) rez = c;
      c = probaj_os( i, -1 );
      if( c > rez ) rez = c;
   }
}

int main( void ) {
   while( input() ) {
      rez = 0;
      solve();
      printf( "%d\n", rez );
   }
   return 0;
}
