
/*
   January 2003 Monthly Contest - Problem D. Knights in FEN
   Team 2. - Kalinovcic, Dondjivic, Kokan
*/

#include <stdio.h>

char t[6];
int rjesenje;
int a[5][5];
int sol[5][5] = { {1, 1, 1, 1, 1},
                  {0, 1, 1, 1, 1},
                  {0, 0, 2, 1, 1},
                  {0, 0, 0, 0, 1},
                  {0, 0, 0, 0, 0} };
int dr[8] = { -2, -2, -1, 1, 2, 2, 1, -1 };
int dc[8] = { -1, 1, 2, 2, 1, -1, -2, -2 };
int rupa_r, rupa_c;

void input() {
   int i, j;
   for( i = 0; i < 5; ++i ) {
      gets( t );
      for( j = 0; j < 5; ++j ) {
         if( t[j] == '0' ) a[i][j] = 0;
         if( t[j] == '1' ) a[i][j] = 1;
         if( t[j] == ' ' ) { rupa_r = i; rupa_c = j; }
      }
   }
}

int ok() {
   int i, j;
   if( rupa_r != 2 || rupa_c != 2 ) return 0;
   for( i = 0; i < 5; ++i )
      for( j = 0; j < 5; ++j ) {
         if( i == 2 && j == 2 ) continue;
         if( a[i][j] != sol[i][j] ) return 0;
      }
   return 1;
}

inline int legal_move( int r, int c ) {
   if( r < 0 || r > 4 ) return 0;
   if( c < 0 || c > 4 ) return 0;
   return 1;
}

void recurse( int depth ) {
   int i, nova_r, nova_c, stara_r, stara_c;
   if( depth > 10 ) return;
   if( ok() ) {
      if( depth < rjesenje ) rjesenje = depth;
      return;
   }
   for( i = 0; i < 8; ++i ) {
      nova_r = rupa_r + dr[i];
      nova_c = rupa_c + dc[i];

      if( !legal_move( nova_r, nova_c ) ) continue;
      if( rupa_r != 2 && rupa_c != 2 &&
          sol[rupa_r][rupa_c] != a[nova_r][nova_c] ) continue;

      a[rupa_r][rupa_c] = a[nova_r][nova_c];

      stara_r = rupa_r; stara_c = rupa_c;
      rupa_r = nova_r; rupa_c = nova_c;

      recurse( depth + 1 );

      rupa_r = stara_r; rupa_c = stara_c;
      a[nova_r][nova_c] = a[rupa_r][rupa_c];
   }
}

int main( void ) {
   int num;
   for( scanf( "%d", &num ), gets( t ); num; --num ) {
      input();
      rjesenje = 11;
      recurse( 0 );
      if( rjesenje == 11 ) printf( "Unsolvable in less than 11 move(s).\n" );
      else printf( "Solvable in %d move(s).\n", rjesenje );
   }
   return 0;
}
