
/*
   January 2003 Monthly Contest - Problem E. Peter Takes a Tramway
   Team 2. - Kalinovcic, Dondjivic, Kokan
*/

#include<stdio.h>
#include<stdlib.h>
#define MAX 60

struct tram { int num, minuta; } trams[MAX];
int n_trams;
int pocetak, stanica;

int cmp( const void *e1, const void *e2 ) {
   return ((struct tram *)e1)->minuta - ((struct tram *)e2)->minuta;
}

int input() {
   int i, n, num, minuta;

   scanf( "%d", &n );
   if( !n ) return 0;

   n_trams = 0;
   for( i = 0; i < n; ++i ) {
      scanf( "%d:", &num );
      while( scanf( "%d", &minuta ) == 1 ) {
         if( minuta == -1 ) break;
         trams[n_trams].num = num;
         trams[n_trams++].minuta = minuta;
      }
   }
   scanf( "%d%d", &pocetak, &stanica );

   qsort( (void *) trams, n_trams, sizeof trams[0], cmp );

   return 1;
}

int tram_number() {
   int i, t = (stanica-1) % n_trams;
   for( i = 0; i < n_trams; ++i )
      if( trams[i].minuta >= pocetak ) break;
   i = (i + t) % n_trams;
   return trams[i].num;
}

int main() {
   int casenum;
   for( casenum = 1; input(); ++casenum ) {
      printf( "Case %d: Peter arrives at stop %d by tram ", casenum, stanica );
      printf( "%d.\n", tram_number() );
   }
   return 0;
}
