
/*
   January 2003 Monthly Contest - Problem H. Knights' Nightmare
   Team 2. - Kalinovcic, Dondjivic, Kokan
*/

#include <stdio.h>
#define INF 10000
#define MAXQ 100000

struct point { int r, c; } kn[4], zamka;
struct qitem { int r, c, bio; } q[MAXQ];
int min[4][16][16][4];
char casename[64];
int qh, qt;
int R, C;
int result, knight;

void qinit() { qh = qt = 0; }
void qpush( int r, int c, int bio ) {
   q[qt].r = r;
   q[qt].c = c;
   q[qt].bio = bio;
   qt = (qt + 1)%MAXQ;
}
int qpop( int *r, int *c, int *bio ) {
   if( qh == qt ) return 0;
   *r = q[qh].r;
   *c = q[qh].c;
   *bio = q[qh].bio;
   qh = (qh + 1)%MAXQ;
   return 1;
}

int input() {
   int i;
   if( scanf( "%s", casename ) != 1 ) return 0;
   scanf( "%d%d", &R, &C );
   for( i = 0; i < 4; ++i ) {
      scanf( "%d%d", &kn[i].r, &kn[i].c );
      kn[i].r--; kn[i].c--;
   }
   scanf( "%d%d", &zamka.r, &zamka.c );
   zamka.r--; zamka.c--;
   return 1;
}

int dr[8] = { -2, -2, -1, 1, 2, 2, 1, -1 };
int dc[8] = { -1, 1, 2, 2, 1, -1, -2, -2 };

void probaj( int r, int c, int b, int val ) {
   if( r < 0 || r >= R ) return;
   if( c < 0 || c >= C ) return;
   if( min[knight][r][c][b] <= val ) return;
   min[knight][r][c][b] = val;
   qpush( r, c, b );
}

void bfs() {
   int i, row, col, bio, novibio;

   qinit();
   probaj( kn[knight].r, kn[knight].c, 0, 0 );

   while( qpop( &row, &col, &bio ) ) {
      novibio = bio;
      if( row == zamka.r && col == zamka.c ) novibio = 1;

      for( i = 0; i < 8; ++i )
         probaj( row + dr[i], col + dc[i], novibio, min[knight][row][col][bio] + 1 );
   }
}

inline int min2( int a, int b ) { return (a<b)?a:b; }

void solve() {
   int i, j, k, t;
   for( i = 0; i < R; ++i )
      for( j = 0; j < C; ++j )
         for( k = 0; k < 4; ++k )
            min[k][i][j][0] = min[k][i][j][1] = INF;

   for( knight = 0; knight < 4; ++knight ) bfs();
   result = INF;
   for( i = 0; i < R; ++i )
      for( j = 0; j < C; ++j ) {
         if( i == zamka.r && j == zamka.c ) continue;
         t =          min[0][i][j][0] + min[1][i][j][0] + min[2][i][j][0] + min[3][i][j][0];
         t = min2( t, min[0][i][j][0] + min[1][i][j][0] + min[2][i][j][0] + min[3][i][j][1] );
         t = min2( t, min[0][i][j][0] + min[1][i][j][0] + min[2][i][j][1] + min[3][i][j][0] );
         t = min2( t, min[0][i][j][0] + min[1][i][j][1] + min[2][i][j][0] + min[3][i][j][0] );
         t = min2( t, min[0][i][j][1] + min[1][i][j][0] + min[2][i][j][0] + min[3][i][j][0] );
         if( t < result ) result = t;
      }
}

int main( void ) {
   while( input() ) {
      solve();

      printf( "%s\n", casename );

      if( result == INF ) printf( "Meeting is impossible.\n" );
      else printf( "Minimum time required is %d minutes.\n", result );
   }
   return 0;
}
