
#include <stdio.h>

#define MAX_GRADOVA 100
#define MAX_DUBINA 200

int broj_gradova,broj_cesta;
int grad_a,grad_b;
int velicina_koraka;
int broj_koraka;
int graf[MAX_GRADOVA][MAX_GRADOVA],novi_graf[MAX_GRADOVA][MAX_GRADOVA];

int pocetak,kraj;
int queue[MAX_DUBINA];

// funkcija "init_queue" inicijalizira queue

void init_queue(void)
{
  pocetak = MAX_DUBINA - 1;
  kraj = 0;
}

// funkcija "enqueue" ubacuje novi broj u queue

void enqueue(int broj)
{
  pocetak = (pocetak + 1) % MAX_DUBINA;
  queue[pocetak] = broj;
}

// funkcija "dequeue" vadi broj iz queue-a

int dequeue(void)
{
  int stari_kraj;

  stari_kraj = kraj;
  kraj = (kraj + 1) % MAX_DUBINA;

  return queue[stari_kraj];
}

// funkcija "queue_size" vraca broj brojeva u queue-u

int queue_size(void)
{
  return ((pocetak + MAX_DUBINA + 1 - kraj) % MAX_DUBINA);
}

// ucitavanje podataka iz "GRAF.IN"

void ucitaj_podatke(void)
{
  int i,j;
  int prvi_grad,drugi_grad;
  FILE *fp;

  fp = fopen("GRAF.IN","rt");

  fscanf(fp,"%d%d%d%d%d",&broj_gradova,&grad_a,&grad_b,&velicina_koraka,
                         &broj_cesta);

  // inicijalizacija polja "graf"

  for (i = 0;i < broj_gradova;++i)
    for (j = 0;j < broj_gradova;++j)
      graf[i][j] = 0;

  for (i = 0;i < broj_cesta;++i)
  {
    fscanf(fp,"%d%d",&prvi_grad,&drugi_grad);
    graf[prvi_grad - 1][drugi_grad - 1] = graf[drugi_grad - 1][prvi_grad - 1] = 1;
  }

  fclose(fp);
}

void rijesi(void)
{
  int i,j,k,l;
  int velicina_reda;
  int vrh;
  int bio[MAX_GRADOVA];

  // inicijalizacija polja "novi_graf"

  for (i = 0;i < broj_gradova;++i)
    for (j = 0;j < broj_gradova;++j)
      novi_graf[i][j] = 0;

  // za svaki vrh u grafu gledam koji su silazni vrhovi udaljeni za velicinu
  // koraka i tako gradim novi graf

  for (i = 0;i < broj_gradova - 1 - velicina_koraka;++i)
  {
    init_queue();
    enqueue(i);

    for (j = 0;j < velicina_koraka;++j)
    {
      velicina_reda = queue_size();

      for (k = 0;k < broj_gradova;++k)
        bio[k] = 0;

      for (k = 0;k < velicina_reda;++k)
      {
        vrh = dequeue();

        for (l = vrh + 1;l < broj_gradova;++l)
          if (graf[vrh][l] && !bio[l])
          {
            enqueue(l);
            bio[l] = 1;
          }
      }
    }

    // ono sto je ostalo u queue-u su vrhovi povezani sa vrhom "i" u novom grafu

    velicina_reda = queue_size();

    for (j = 0;j < velicina_reda;++j)
    {
      vrh = dequeue();

      novi_graf[i][vrh] = novi_graf[vrh][i] = 1;
    }
  }

  for (i = 0;i < broj_gradova;++i)
    bio[i] = 0;

  init_queue();
  enqueue(grad_a - 1);

  broj_koraka = 0;

  // preko bfs-a u novom grafu racunam kolika je minimalna udaljenost izmedju
  // grada "grad_a" i grada "grad_b"

  do
  {
    velicina_reda = queue_size();

    ++broj_koraka;

    for (i = 0;i < velicina_reda;++i)
    {
      vrh = dequeue();
      bio[vrh] = 1;

      for (j = 0;j < broj_gradova;++j)
        if (novi_graf[vrh][j] && !bio[j])
        {
          if (j == grad_b - 1)
            return;

          enqueue(j);
        }
    }
  } while (1);
}

int main(void)
{
  ucitaj_podatke();
  rijesi();

  printf("\nBroj koraka = %d\n",broj_koraka);

  return 0;
}
