
#include <stdio.h>

int vrijednost_crvenih,vrijednost_zutih,vrijednost_zelenih;
int donja_granica,gornja_granica;
int broj_zetona;

int polje[41],staro_polje[41];

// funkcija "popuni" popunjava niz "polje" s novim vrijednostima

void popuni(int vrijednost,int broj)
{
  int i,j;

  // kreiranje kopije niza "polje"

  for (i = 0;i <= gornja_granica;++i)
    staro_polje[i] = polje[i];

  // popunjavanje niza "polje" na temelju vrijednosti iz niza "staro_polje"

  for (i = 0;i <= gornja_granica - vrijednost;++i)
    if (staro_polje[i])
      for (j = 1;j <= broj;++j)
        if (i + j * vrijednost <= gornja_granica)
          polje[i + j * vrijednost] = 1;
}

void rijesi(void)
{
  int i;
  int broj_crvenih,broj_zutih,broj_zelenih;
  int ok;

  // inicijalizacija varijable "broj_zetona" na maksimalnu vrijednost

  broj_zetona = 40;

  // isprobavanje za sve moguce kombinacije broja crvenih, zutih i zelenih zetona

  for (broj_crvenih = 0;broj_crvenih <= gornja_granica / vrijednost_crvenih;++broj_crvenih)
    for (broj_zutih = 0;broj_zutih <= gornja_granica / vrijednost_zutih;++broj_zutih)
      for (broj_zelenih = 0;broj_zelenih <= gornja_granica / vrijednost_zelenih;++broj_zelenih)
        if (broj_crvenih + broj_zutih + broj_zelenih < broj_zetona)
        {
          // inicijalizacija niza "polje", svugdje je false, osim na pocetku

          polje[0] = 1;
          for (i = 1;i <= gornja_granica;++i)
            polje[i] = 0;

          // pozivanje funkcije "popuni", za crvene, zute i zelene zetone

          popuni(vrijednost_crvenih,broj_crvenih);
          popuni(vrijednost_zutih,broj_zutih);
          popuni(vrijednost_zelenih,broj_zelenih);

          // ispitivanje da li je svaka vrijednost izmedju "donja_granica" i
          // "gornja_granica" ostvariva trenutnim brojem zetona

          ok = 1;

          for (i = donja_granica;i <= gornja_granica;++i)
            if (!polje[i])
            {
              ok = 0;
              break;
            }

          if (ok)
            broj_zetona = broj_crvenih + broj_zutih + broj_zelenih;
        }
}

int main(void)
{
  printf("\nUpisite brojeve A, B, C, D i E : ");
  scanf("%d%d%d%d%d",&vrijednost_crvenih,&vrijednost_zutih,
                     &vrijednost_zelenih,&donja_granica,&gornja_granica);

  rijesi();

  printf("\nBroj zetona = %d\n",broj_zetona);

  return 0;
}
