
#include <stdio.h>
#include <stdlib.h>

#define MAX_BROJEVA 100

int duljina_niza;
int niz_brojeva[MAX_BROJEVA],sortirani_niz[MAX_BROJEVA];

int broj_poteza;

// ucitavanje podataka iz "SORT.IN"

void ucitaj_podatke(void)
{
  int i;
  FILE *fp;

  fp = fopen("SORT.IN","rt");

  fscanf(fp,"%d",&duljina_niza);

  for (i = 0;i < duljina_niza;++i)
    fscanf(fp,"%d",niz_brojeva + i);

  fclose(fp);
}

// funkcija "nadji_duzinu" vraca koliki je maksimalni broj uzastopnih
// elemenata s pocetka niza "sortirani_niz" koji se u nizu "niz_brojeva"
// nalaze u istom poretku, ali nisu nuzno uzastopni

int nadji_duzinu(void)
{
  int i,j;
  int broj;
  int nasao;

  broj = 0;

  for (i = 0;i < duljina_niza;++i)
  {
    nasao = 0;

    for (j = broj;j < duljina_niza;++j)
      if (niz_brojeva[j] == sortirani_niz[i])
      {
        nasao = 1;
        broj = j + 1;

        break;
      }

    if (!nasao)
      return i;
  }

  return duljina_niza;
}

// funkcija "rijesi" poziva funkciju "nadji_duzinu" dva puta, prvi put u
// nizu "niz_brojeva" su brojevi iz ulazne datoteke, a u nizu
// "sortirani_niz" je uzlazno sortirani "niz_brojeva", a drugi put su u
// nizu "niz_brojeva" preokrenuti brojevi iz ulazne datoteke, a u nizu
// "sortirani_niz" silazno sortirani "niz_brojeva"

void rijesi(void)
{
  int i,j;
  int temp;
  int na_pocetak,na_kraj;

  // kopiranje niza "niz_brojeva" u "sortirani_niz"

  for (i = 0;i < duljina_niza;++i)
    sortirani_niz[i] = niz_brojeva[i];

  // sortiranje niza "sortirani_niz"

  for (i = 0;i < duljina_niza - 1;++i)
    for (j = i + 1;j < duljina_niza;++j)
      if (sortirani_niz[i] > sortirani_niz[j])
      {
        temp = sortirani_niz[i];
        sortirani_niz[i] = sortirani_niz[j];
        sortirani_niz[j] = temp;
      }

  na_kraj = nadji_duzinu();

  // preokretanje niza "niz_brojeva" i "sortirani_niz"

  for (i = 0;i < duljina_niza / 2;++i)
  {
    temp = niz_brojeva[i];
    niz_brojeva[i] = niz_brojeva[duljina_niza - i - 1];
    niz_brojeva[duljina_niza - i - 1] = temp;

    temp = sortirani_niz[i];
    sortirani_niz[i] = sortirani_niz[duljina_niza - i - 1];
    sortirani_niz[duljina_niza - i - 1] = temp;
  }

  na_pocetak = nadji_duzinu();

  // "broj_poteza" je jednak razlici duljine niza i manjeg od dva broja
  // dobivena pozivanjem funkcije "nadji_duzinu"

  broj_poteza = duljina_niza - max(na_pocetak,na_kraj);
}

int main(void)
{
  ucitaj_podatke();
  rijesi();

  printf("\nBroj poteza = %d\n",broj_poteza);

  return 0;
}
